import { APIService } from '../api.service';
import { WebhookEntity } from '../../entities/webhook.entity';
import { SMSTransactionEntity } from '../../entities/sms/sms-transaction.entity';
import { PartnerEntity } from '../../entities/partner.entity';
import { EWebhookStatus } from '../../enums/webhook.enum';
import { WebhookRepository } from '../../repositories/webhook.repository';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { SearchWebhookDto } from '../../dtos/webhook.dto';
import { SMSRepository } from 'src/repositories/sms/sms.repository';
import { PartnerRepository } from 'src/repositories/partner.repository';
import { SMSTransactionRepository } from 'src/repositories/sms/sms-transaction.repository';
import { SMSEntity } from 'src/entities/sms/sms.entity';
import { ShortCodeEntity } from 'src/entities/short-code/short-code.entity';
import { SMSRecipientEntity } from 'src/entities/sms/sms-recipient.entity';
export declare class WebhookService {
    protected apiService: APIService;
    protected webhookRepository: WebhookRepository;
    protected smsRepository: SMSRepository;
    protected smsTransactionRepository: SMSTransactionRepository;
    protected partnerRepository: PartnerRepository;
    private readonly maxRetries;
    private readonly retryDelay;
    constructor(apiService: APIService, webhookRepository: WebhookRepository, smsRepository: SMSRepository, smsTransactionRepository: SMSTransactionRepository, partnerRepository: PartnerRepository);
    sendSMSStatusUpdateWebhook(conf: {
        sms: SMSEntity;
        shortCode: ShortCodeEntity;
        smsRecipient: SMSRecipientEntity;
        smsTransaction: Omit<SMSTransactionEntity, 'recipient'>;
    }, partner: PartnerEntity, config?: {
        throwError?: boolean;
    }): Promise<void>;
    private getWebhookEventType;
    sendWebhookBySMSTransactionId(smsId: string, auth: IAuthParam): Promise<void>;
    private buildWebhookPayload;
    private sendWebhook;
    private handleWebhookError;
    getWebhookStats(partnerId: string): Promise<{
        total: number;
        delivered: number;
        failed: number;
        pending: number;
        retrying: number;
    }>;
    search({ errorMessage, responseBody, ...query }: SearchWebhookDto, auth: IAuthParam): Promise<import("@serene-dev/la-nest-library").ISearchResponse<WebhookEntity>>;
    resendWebhook(webhookId: string, auth: IAuthParam): Promise<{
        webhookId: string;
        status: EWebhookStatus;
        retryCount: number;
        message: string;
    }>;
    getWebhookById(webhookId: string, auth: IAuthParam): Promise<WebhookEntity>;
}
export declare class WebhookServiceModule {
}
