"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UtilityClass = void 0;
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const axios_1 = require("axios");
const index_config_1 = require("../configs/index.config");
const environment_service_1 = require("./environment.service");
const promises_1 = require("fs/promises");
const path = require("path");
const mail_template_config_1 = require("../configs/mail-template.config");
class UtilityClass extends la_nest_library_1.SDKUtilityClass {
    static get relativeUploadPath() {
        return environment_service_1.evt.MULTER_DEST;
    }
    static get absoluteUploadPath() {
        return path.join(this.absolutePath, this.relativeUploadPath);
    }
    static get currentGMTTimestamp() {
        const diff = environment_service_1.evt.timestampDifferenceFromGMT;
        return Date.now() + environment_service_1.evt.timestampDifferenceFromGMT || 0;
    }
    static get currentLocalDateTime() {
        return this.convertDateToLocalDate(Date.now());
    }
    static get currentLocalDate() {
        return this.convertDateTimeToDate(Date.now());
    }
    static yesterdayLocalDate(date = Date.now()) {
        return this.convertDateTimeToDate(new Date(date).getTime() - index_config_1.Config.TimeStampDay);
    }
    static tomorrowLocalDate(date = Date.now()) {
        return this.convertDateTimeToDate(new Date(date).getTime() + index_config_1.Config.TimeStampDay * 3);
    }
    static convertDateToLocalDate(date) {
        return new Date(date).toISOString();
    }
    static convertDateTimeToDate(date) {
        return new Date(date).toISOString().split('T')[0];
    }
    static addDaysToDate(date, days) {
        return this.convertDateTimeToDate(index_config_1.Config.TimeStampDay * days + new Date(date).getTime());
    }
    static calculateTimeZoneDifferenceMilliSec() {
        return (new Date().getTimezoneOffset() + 60) * 60 * 1000;
    }
    static calculateTimeZoneDifferenceMins() {
        return new Date().getTimezoneOffset() + 60;
    }
    static getNextDayDate(nextDay, currentDate = Date.now()) {
        const cd = new Date(currentDate);
        const cdDay = cd.getDay();
        const daysToadd = nextDay - cdDay;
        const cdDate = cd.getDate();
        return _a.convertDateTimeToDate(cd.getDay() == nextDay ? cd : new Date(cd.setDate(cdDate + daysToadd)));
    }
    static dateRange(startDate, endDate, steps = 1) {
        const dateArray = [];
        const currentDate = new Date(startDate);
        while (currentDate <= new Date(endDate)) {
            dateArray.push(new Date(currentDate).toISOString().split('T')[0]);
            currentDate.setUTCDate(currentDate.getUTCDate() + steps);
        }
        return dateArray;
    }
    static getBase64Image(img) {
        const canvas = document.createElement('canvas');
        canvas.width = img.width;
        canvas.height = img.height;
        const ctx = canvas.getContext('2d');
        ctx.drawImage(img, 0, 0);
        const dataURL = canvas.toDataURL('image/png');
        return dataURL.replace(/^data:image\/?[A-z]*;base64,/, '');
    }
    static imageURLToBase64(url) {
        return axios_1.default.get(url).then((r) => {
            return ('data:' +
                r.headers['content-type'] +
                ';base64,' +
                Buffer.from(r.data).toString('base64'));
        });
    }
    static async writeFile(folderPath, fileName, data) {
        const fullPath = `${folderPath}/${fileName}`;
        const _writeFile = () => (0, promises_1.writeFile)(fullPath, data);
        return (0, promises_1.open)(fullPath, 'w')
            .then(async (fh) => {
            await _writeFile();
            fh.close();
        })
            .catch((err) => {
            if (err.errno == -2)
                return (0, promises_1.mkdir)(folderPath).then(() => _writeFile());
            else
                throw err;
        });
    }
    static async readFile(filePath, throwErr = false) {
        try {
            return JSON.parse((await (0, promises_1.readFile)(path.join(__dirname, filePath))).toString());
        }
        catch (error) {
            console.error(error);
            if (throwErr)
                _a.throwError({ error });
            else
                return null;
        }
    }
    static async search(repository, query, config) {
        return super.search(repository, query, config);
    }
    static getServerURL() {
        return environment_service_1.evt.SERVER_URL;
    }
    static async emailTemplater(header, body) {
        return mail_template_config_1.mailTemplates.general({ header, body });
    }
}
exports.UtilityClass = UtilityClass;
_a = UtilityClass;
UtilityClass.gameSenderName = 'Game Man';
UtilityClass.absolutePath = __dirname;
UtilityClass.convertToDateString = (date) => {
    return _a.datetoJson(date).substr(0, 10);
};
UtilityClass.datetoJson = (date) => {
    const newDate = new Date(date);
    newDate.setMinutes(newDate.getMinutes() + 60);
    return newDate.toJSON();
};
UtilityClass.getGameweekString = (start, end) => {
    return (_a.convertToDateString(start) + '|' + _a.convertToDateString(end));
};
UtilityClass.getGameweekDate = () => {
    const today = new Date();
    const day = today.getDay();
    if (day >= 2) {
        const daysToStartDay = day - 2;
        const date = today.getDate() - daysToStartDay;
        const startDate = new Date();
        startDate.setDate(date);
        const endDate = new Date(startDate);
        endDate.setDate(endDate.getDate() + 6);
        return { startDate, endDate };
    }
    else {
        const daysToEndDay = 1 - day;
        const date = today.getDate() + daysToEndDay;
        const endDate = new Date();
        endDate.setDate(date);
        const startDate = new Date(endDate);
        startDate.setDate(startDate.getDate() - 6);
        return { startDate, endDate };
    }
};
UtilityClass.createQueue = (config) => {
    const queue = [];
    let waitingForTimeoutToCallActioner = false;
    const inProcess = (() => {
        let processes = 0;
        return {
            add: () => ++processes,
            remove: () => --processes,
            hasProcesses: () => processes > 0,
            count: () => processes,
            freeSpace: () => config?.chunkSize - processes,
        };
    })();
    const intervalSeconds = config?.intervalSeconds || (environment_service_1.evt.isDev ? 2 : 60);
    const actioner = () => {
        if (waitingForTimeoutToCallActioner ||
            queue.length == 0 ||
            inProcess.freeSpace() == 0)
            return;
        const slice = queue.splice(0, inProcess.freeSpace());
        console.log('queue state', getQueue());
        slice.forEach(async (s) => {
            inProcess.add();
            try {
                await s.next();
            }
            catch (error) {
                if (error?.['response']?.status == 429 ||
                    error?.['statusCode'] == 429)
                    add(s);
                else {
                    s.onError(error);
                    la_nest_library_1.logger.error({ type: `queue error`, error });
                }
            }
            inProcess.remove();
        });
        debounceActionerCall(intervalSeconds);
    };
    const debounceActionerCall = (seconds) => {
        if (waitingForTimeoutToCallActioner)
            return;
        waitingForTimeoutToCallActioner = true;
        setTimeout(() => {
            waitingForTimeoutToCallActioner = false;
            actioner();
        }, 1000 * seconds);
    };
    const add = (item) => {
        const queueLength = queue.length;
        queue.push(item);
        postAddCheck(queueLength);
    };
    const postAddCheck = (preAddQueueLength) => {
        if (!inProcess.hasProcesses() && preAddQueueLength == 0) {
            debounceActionerCall(1);
        }
    };
    const getQueue = () => ({
        currentTime: new Date(),
        freeSpace: inProcess.freeSpace(),
        inProcess: inProcess.hasProcesses(),
        inProcessCount: inProcess.count(),
        intervalInSeconds: intervalSeconds,
        itemsWaitingInQueue: queue.length,
        waitingForTimeoutToCallActioner: waitingForTimeoutToCallActioner,
    });
    return {
        getQueue,
        clear: () => queue.splice(0),
        addBatch: (items) => {
            const queueLength = queue.length;
            queue.push(...items);
            postAddCheck(queueLength);
        },
        add,
    };
};
la_nest_library_1.SDKUtilityClass.emailTemplater = UtilityClass.emailTemplater;
la_nest_library_1.SDKUtilityClass.swaggerUILink = 'http://localhost:7100/solo-docs';
//# sourceMappingURL=utility.service.js.map