import { ISearchResponse, SDKUtilityClass } from '@serene-dev/la-nest-library';
import { FindOptionsOrder, FindOptionsRelations, FindOptionsSelect, FindOptionsWhere, Repository } from 'typeorm';
import { SearchQueryDto } from 'src/entities/base.entity';
export declare class UtilityClass extends SDKUtilityClass {
    static gameSenderName: string;
    static get relativeUploadPath(): string;
    static readonly absolutePath: string;
    static get absoluteUploadPath(): string;
    static convertToDateString: (date: any) => string;
    static datetoJson: (date: any) => string;
    static getGameweekString: (start: any, end: any) => string;
    static get currentGMTTimestamp(): number;
    static get currentLocalDateTime(): string;
    static get currentLocalDate(): string;
    static yesterdayLocalDate(date?: string | Date | number): string;
    static tomorrowLocalDate(date?: string | Date | number): string;
    static convertDateToLocalDate(date: string | number | Date): string;
    static convertDateTimeToDate(date: string | number | Date): string;
    static addDaysToDate(date: string | number | Date, days: number): string;
    static calculateTimeZoneDifferenceMilliSec(): number;
    static calculateTimeZoneDifferenceMins(): number;
    static getNextDayDate(nextDay: number, currentDate?: string | number | Date): string;
    static dateRange(startDate: any, endDate: any, steps?: number): string[];
    static getBase64Image(img: HTMLImageElement): string;
    static imageURLToBase64(url: string): Promise<string>;
    static getGameweekDate: () => {
        startDate: Date;
        endDate: Date;
    };
    static writeFile(folderPath: string, fileName: string, data: any): Promise<void>;
    static readFile<T = any>(filePath: string, throwErr?: boolean): Promise<T>;
    static search<TSearchQuery extends SearchQueryDto, TEntity>(repository: Repository<TEntity>, query: TSearchQuery, config?: {
        baseWhere?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[];
        baseOrder?: FindOptionsOrder<TEntity>;
        baseRelations?: FindOptionsRelations<TEntity>;
        baseSelect?: FindOptionsSelect<TEntity>;
    }): Promise<ISearchResponse<TEntity>>;
    static getServerURL(): string;
    static createQueue: (config?: {
        intervalSeconds?: number;
        chunkSize?: number;
    }) => {
        getQueue: () => {
            currentTime: Date;
            freeSpace: number;
            inProcess: boolean;
            inProcessCount: number;
            intervalInSeconds: number;
            itemsWaitingInQueue: number;
            waitingForTimeoutToCallActioner: boolean;
        };
        clear: () => QueueItem[];
        addBatch: (items: QueueItem[]) => void;
        add: (item: QueueItem) => void;
    };
    static emailTemplater(header: string, body: string): Promise<string>;
}
type QueueItem = {
    next: () => Promise<any>;
    onError: (error: any) => any;
};
export {};
