"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSViewsServiceModule = exports.SMSViewsService = void 0;
const common_1 = require("@nestjs/common");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../utility.service");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const sms_view_entity_1 = require("../../entities/sms/sms.view.entity");
const client_service_1 = require("../partner/client.service");
const typeorm_3 = require("@nestjs/typeorm");
const sms_transaction_repository_1 = require("../../repositories/sms/sms-transaction.repository");
let SMSViewsService = class SMSViewsService {
    constructor(repoSMSTransactionView, repoSMSTransactionAdminView, smsTransactionRepository, clientService) {
        this.repoSMSTransactionView = repoSMSTransactionView;
        this.repoSMSTransactionAdminView = repoSMSTransactionAdminView;
        this.smsTransactionRepository = smsTransactionRepository;
        this.clientService = clientService;
        this.baseRelations = {
            provider: true,
            recipient: { sms: { client: true } },
        };
        this.sharedBaseWhereQuery = ({ message, ...query }) => {
            return {
                baseWhere: message
                    ? {
                        recipient: { sms: { message: (0, typeorm_1.Like)(`%${message}%`) } },
                    }
                    : null,
                restQuery: query,
            };
        };
    }
    async searchTransactions({ orgID, ...query }, auth) {
        const { baseWhere, restQuery } = this.sharedBaseWhereQuery(query);
        orgID = auth?.isClient
            ? auth.id
            : auth?.isPublic
                ? await this.clientService.getClientIDByAuthID(auth.id)
                : orgID;
        return utility_service_1.UtilityClass.search(this.smsTransactionRepository, restQuery, {
            baseWhere: { ...baseWhere, recipient: { sms: { clientId: orgID } } },
            baseRelations: this.baseRelations,
            baseSelect: {},
        });
    }
    searchTransactionsAdmin(query) {
        const { baseWhere, restQuery } = this.sharedBaseWhereQuery(query);
        return utility_service_1.UtilityClass.search(this.smsTransactionRepository, restQuery, {
            baseWhere,
            baseRelations: this.baseRelations,
        });
    }
};
exports.SMSViewsService = SMSViewsService;
SMSViewsService.path = new la_nest_library_1.RoutePath('sms');
exports.SMSViewsService = SMSViewsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(sms_view_entity_1.SMSTransactionView)),
    __param(1, (0, typeorm_2.InjectRepository)(sms_view_entity_1.SMSTransactionAdminView)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        sms_transaction_repository_1.SMSTransactionRepository,
        client_service_1.ClientService])
], SMSViewsService);
let SMSViewsServiceModule = class SMSViewsServiceModule {
};
exports.SMSViewsServiceModule = SMSViewsServiceModule;
exports.SMSViewsServiceModule = SMSViewsServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [
            typeorm_3.TypeOrmModule.forFeature([sms_view_entity_1.SMSTransactionView, sms_view_entity_1.SMSTransactionAdminView]),
        ],
        providers: [SMSViewsService],
        exports: [SMSViewsService],
    })
], SMSViewsServiceModule);
//# sourceMappingURL=sms.view.service.js.map