import { SearchSMSAdminDTO, SearchSMSDTO } from '../../dtos/sms.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { RoutePath } from '@serene-dev/la-nest-library';
import { FindOptionsWhere, Repository } from 'typeorm';
import { SMSTransactionAdminView, SMSTransactionView } from '../../entities/sms/sms.view.entity';
import { ClientService } from '../partner/client.service';
import { SMSTransactionRepository } from 'src/repositories/sms/sms-transaction.repository';
import { SMSTransactionEntity } from 'src/entities/sms/sms-transaction.entity';
export declare class SMSViewsService {
    repoSMSTransactionView: Repository<SMSTransactionView>;
    repoSMSTransactionAdminView: Repository<SMSTransactionAdminView>;
    smsTransactionRepository: SMSTransactionRepository;
    clientService: ClientService;
    static path: RoutePath;
    readonly baseRelations: {
        readonly provider: true;
        readonly recipient: {
            readonly sms: {
                readonly client: true;
            };
        };
    };
    constructor(repoSMSTransactionView: Repository<SMSTransactionView>, repoSMSTransactionAdminView: Repository<SMSTransactionAdminView>, smsTransactionRepository: SMSTransactionRepository, clientService: ClientService);
    protected sharedBaseWhereQuery: ({ message, ...query }: SearchSMSDTO) => {
        baseWhere: FindOptionsWhere<SMSTransactionEntity> | FindOptionsWhere<SMSTransactionEntity>[];
        restQuery: SearchSMSDTO;
    };
    searchTransactions({ orgID, ...query }: SearchSMSDTO, auth: IAuthParam): Promise<import("@serene-dev/la-nest-library").ISearchResponse<SMSTransactionEntity>>;
    searchTransactionsAdmin(query: SearchSMSAdminDTO): Promise<import("@serene-dev/la-nest-library").ISearchResponse<SMSTransactionEntity>>;
}
export declare class SMSViewsServiceModule {
}
