"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSServiceModule = exports.SMSService = void 0;
const common_1 = require("@nestjs/common");
const client_service_1 = require("../partner/client.service");
const sms_recipient_repository_1 = require("../../repositories/sms/sms-recipient.repository");
const sms_transaction_repository_1 = require("../../repositories/sms/sms-transaction.repository");
const sms_repository_1 = require("../../repositories/sms/sms.repository");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const sms_provider_service_1 = require("./sms-providers/sms-provider.service");
const short_code_service_1 = require("../short-code/short-code.service");
const utility_service_1 = require("../utility.service");
const typeorm_1 = require("typeorm");
const product_service_1 = require("../product.service");
const sms_enum_1 = require("../../enums/sms/sms.enum");
const typeorm_2 = require("@nestjs/typeorm");
const sms_entity_1 = require("../../entities/sms/sms.entity");
const short_code_enum_1 = require("../../enums/short-code.enum");
let SMSService = class SMSService {
    constructor(clientService, smsProviderService, smsRepository, smsTransactionRepository, smsRecipienRepository, shortCodeService, productService) {
        this.clientService = clientService;
        this.smsProviderService = smsProviderService;
        this.smsRepository = smsRepository;
        this.smsTransactionRepository = smsTransactionRepository;
        this.smsRecipienRepository = smsRecipienRepository;
        this.shortCodeService = shortCodeService;
        this.productService = productService;
        this.dtoToEntity = (dto) => ({
            message: dto.message,
            productId: null,
            type: dto.type,
            recipients: dto.recipients.map((r) => ({
                recipient: this.numberFormatter(r),
                sms: null,
                transaction: null,
            })),
            client: null,
            clientId: null,
            shortCode: {
                code: dto.shortCode,
                status: short_code_enum_1.EShortCodeStatus.whitelisted,
            },
            shortCodeId: null,
        });
        this.numberFormatter = (receipientNum) => {
            if (receipientNum.startsWith('234'))
                return receipientNum;
            else if (receipientNum.startsWith('+234'))
                return '234' + receipientNum.slice(4);
            else if (!receipientNum.startsWith('234'))
                return '234' + receipientNum.slice(1);
        };
        this.searchTransactions = ({ message, type, receipient, ...query }, auth) => {
            const isAdmin = auth?.isAdmin == true ? true : undefined;
            return utility_service_1.UtilityClass.search(this.smsTransactionRepository, query, {
                baseWhere: {
                    recipient: {
                        sms: { type, message: message ? (0, typeorm_1.Like)(`%${message}%`) : null },
                        recipient: receipient,
                    },
                },
                baseRelations: {
                    recipient: {
                        sms: isAdmin
                            ? { client: true, shortCode: true }
                            : { shortCode: true },
                    },
                    provider: isAdmin,
                },
                baseSelect: {
                    id: true,
                    recipient: {
                        recipient: true,
                        sms: {
                            message: true,
                            client: isAdmin ? { id: true, name: true } : null,
                            shortCode: { code: true, id: true },
                            type: true,
                        },
                    },
                    status: true,
                    amount: true,
                    dateTimeDelivered: true,
                    dateTimeFailed: true,
                    dateTimeSent: true,
                    error: true,
                    resolvedFeedback: isAdmin,
                    createdAt: isAdmin,
                    pErrorCode: isAdmin,
                    pErrorMessage: isAdmin,
                    pMessageID: isAdmin,
                    updatedAt: isAdmin,
                    provider: isAdmin ? { name: true, id: true } : null,
                },
            });
        };
    }
    async send(data, auth, config) {
        const client = await this.clientService.authToClient(auth);
        const shortCode = await this.shortCodeService.getByCode(data.shortCode, auth.id);
        const receipientsMap = {};
        for (let index = 0; index < data.recipients.length; index++) {
            data.recipients[index] = this.numberFormatter(data.recipients[index]);
            receipientsMap[data.recipients[index]] = true;
        }
        data.recipients = Object.keys(receipientsMap);
        const sms = await this.smsRepository.save(this.smsRepository.create({
            message: data.message,
            type: data.type,
            client,
            clientId: client?.id,
            shortCode,
            productId: data.type == sms_enum_1.ESMSType.promotional
                ? client?.currentPromotionalProductId
                : data.type == sms_enum_1.ESMSType.transactional
                    ? client?.currentTransactionalProductId
                    : null,
            recipients: data.recipients.map((receipient) => this.smsRecipienRepository.create({ recipient: receipient })),
        }));
        return this.smsProviderService.send(sms, config);
    }
    async sendBulk(body, auth) {
        const client = await this.clientService.authToClient(auth);
        const smses = await Promise.all(body.data.map(async (data) => {
            const shortCode = await this.shortCodeService.getByCode(data.shortCode);
            return this.smsRepository.save(this.smsRepository.create({
                message: data.message,
                type: data.type,
                clientId: client.id,
                shortCode,
                recipients: data.recipients.map((receipient) => this.smsRecipienRepository.create({ recipient: receipient })),
            }));
        }));
        return this.smsProviderService.sendBulk(client, smses);
    }
    async reconcileMessageStatuses(query, auth) {
    }
};
exports.SMSService = SMSService;
SMSService.path = new la_nest_library_1.RoutePath('sms');
exports.SMSService = SMSService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [client_service_1.ClientService,
        sms_provider_service_1.SMSProviderService,
        sms_repository_1.SMSRepository,
        sms_transaction_repository_1.SMSTransactionRepository,
        sms_recipient_repository_1.SMSRecipienRepository,
        short_code_service_1.ShortCodeService,
        product_service_1.ProductService])
], SMSService);
let SMSServiceModule = class SMSServiceModule {
};
exports.SMSServiceModule = SMSServiceModule;
exports.SMSServiceModule = SMSServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_2.TypeOrmModule.forFeature([sms_entity_1.SMSEntity])],
        providers: [SMSService],
        exports: [SMSService],
    })
], SMSServiceModule);
//# sourceMappingURL=sms.service.js.map