import { ClientService } from '../partner/client.service';
import { ReconcileSMSDTO, SearchSMSAdminDTO, SendBulkSMSDto, SendSMSConfig, SendSMSDto } from '../../dtos/sms.dto';
import { SMSRecipienRepository } from '../../repositories/sms/sms-recipient.repository';
import { SMSTransactionRepository } from '../../repositories/sms/sms-transaction.repository';
import { SMSRepository } from '../../repositories/sms/sms.repository';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { RoutePath } from '@serene-dev/la-nest-library';
import { SMSProviderService } from './sms-providers/sms-provider.service';
import { ShortCodeService } from '../short-code/short-code.service';
import { ProductService } from '../product.service';
import { SMSEntity } from '../../entities/sms/sms.entity';
export declare class SMSService {
    protected clientService: ClientService;
    protected smsProviderService: SMSProviderService;
    protected smsRepository: SMSRepository;
    protected smsTransactionRepository: SMSTransactionRepository;
    protected smsRecipienRepository: SMSRecipienRepository;
    protected shortCodeService: ShortCodeService;
    protected productService: ProductService;
    static path: RoutePath;
    constructor(clientService: ClientService, smsProviderService: SMSProviderService, smsRepository: SMSRepository, smsTransactionRepository: SMSTransactionRepository, smsRecipienRepository: SMSRecipienRepository, shortCodeService: ShortCodeService, productService: ProductService);
    dtoToEntity: (dto: SendSMSDto) => SMSEntity;
    numberFormatter: (receipientNum: string) => string;
    send(data: SendSMSDto, auth: IAuthParam, config?: SendSMSConfig): Promise<import("../../dtos/sms.dto").SendSMSResponseDto[]>;
    sendBulk(body: SendBulkSMSDto, auth: IAuthParam): Promise<import("../../dtos/sms.dto").SendSMSResponseDto[]>;
    searchTransactions: ({ message, type, receipient, ...query }: SearchSMSAdminDTO, auth: IAuthParam) => Promise<import("@serene-dev/la-nest-library").ISearchResponse<import("../../entities/sms/sms-transaction.entity").SMSTransactionEntity>>;
    reconcileMessageStatuses(query: ReconcileSMSDTO, auth: IAuthParam): Promise<void>;
}
export declare class SMSServiceModule {
}
