"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSTransactionServiceModule = exports.SMSTransactionService = void 0;
const common_1 = require("@nestjs/common");
const client_service_1 = require("../partner/client.service");
const sms_transaction_repository_1 = require("../../repositories/sms/sms-transaction.repository");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const sms_enum_1 = require("../../enums/sms/sms.enum");
const base_enum_1 = require("../../enums/base.enum");
const wallet_enum_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.enum");
const sms_transaction_entity_1 = require("../../entities/sms/sms-transaction.entity");
const typeorm_1 = require("@nestjs/typeorm");
const webhook_service_1 = require("../webhook/webhook.service");
let SMSTransactionService = class SMSTransactionService {
    constructor(walletTransactionService, smsTransactionRepository, clientService, loggerDbService, webhookService) {
        this.walletTransactionService = walletTransactionService;
        this.smsTransactionRepository = smsTransactionRepository;
        this.clientService = clientService;
        this.loggerDbService = loggerDbService;
        this.webhookService = webhookService;
        this.walletTransRefCat = `SMS_TRANSACTION`;
        this.amountExtractor = async (data) => {
            try {
                const [wallet, _currentPlan] = await Promise.all([
                    this.clientService.getWalletByClientIDLite(data.clientId, data.type),
                    this.clientService.getCurrentPlan(data.clientId),
                ]);
                const currentPlan = data.type == sms_enum_1.ESMSType.promotional
                    ? _currentPlan?.currentPromotionalProduct
                    : data.type == sms_enum_1.ESMSType.transactional
                        ? _currentPlan?.currentTransactionalProduct
                        : null;
                if (!currentPlan || !currentPlan.active)
                    return { wallet, amount: 0, error: sms_enum_1.ESMSResponseCode.noActivePlan };
                const amount = data.type == sms_enum_1.ESMSType.promotional
                    ? currentPlan.promotional.amount
                    : data.type == sms_enum_1.ESMSType.transactional
                        ? currentPlan.transactional.amount
                        : 0;
                if (!amount)
                    return { wallet, amount, error: sms_enum_1.ESMSResponseCode.noActivePlan };
                if (!wallet)
                    return { wallet, amount, error: sms_enum_1.ESMSResponseCode.noWallet };
                const totalCost = data.recipients.length * amount;
                if (wallet.grossBalance < totalCost)
                    return { wallet, amount, error: sms_enum_1.ESMSResponseCode.insufficientBalance };
                return { wallet, amount };
            }
            catch (error) {
                this.loggerDbService._create({
                    message: error,
                    refCat: base_enum_1.ELoggerRefCat.sendSMS,
                    refNo: data.id,
                    orgID: data.clientId,
                    isError: true,
                });
                return { wallet: null, amount: 0, error: sms_enum_1.ESMSResponseCode.internalError };
            }
        };
    }
    async create(data, provider, config) {
        const { amount, error, wallet } = await this.amountExtractor(data);
        await this.smsTransactionRepository.manager.transaction(async (manager) => {
            await Promise.all(data.recipients.map(async (recipient) => {
                const trans = await manager.save(this.smsTransactionRepository.create({
                    amount: data.shortCode ? amount : 0,
                    recipientId: recipient.id,
                    status: data.shortCode ? sms_enum_1.ESMSStatus.pending : sms_enum_1.ESMSStatus.failed,
                    error: error ||
                        (data.shortCode ? null : sms_enum_1.ESMSResponseCode.invalidSenderId),
                    providerId: provider.id,
                    resolvedFeedback: !!error,
                }));
                recipient.transaction = trans;
                if (wallet && !error)
                    await this.walletTransactionService
                        .create(wallet.id, {
                        amount,
                        currency: wallet_enum_1.ECurrency.naira,
                        isFailed: false,
                        isVerified: true,
                        reason: `Sent SMS`,
                        surcharge: 0,
                        transactionReference: trans.id,
                        transMethod: wallet_enum_1.ETransMethod.system,
                        type: wallet_enum_1.ETransactionType.debit,
                        refCat: this.walletTransRefCat,
                    }, { entityManager: manager })
                        .then((wTrans) => manager.update(sms_transaction_entity_1.SMSTransactionEntity, { id: trans.id }, { walletTransactionId: wTrans.id }));
            }));
        });
        return { error };
    }
    async update(transactionId, update, sendWebhook = true) {
        const result = await this.smsTransactionRepository.update({ id: transactionId }, update);
        if (sendWebhook && update.status) {
            try {
                const transaction = await this.smsTransactionRepository.findOne({
                    where: { id: transactionId },
                    relations: {
                        recipient: {
                            sms: {
                                client: true,
                                shortCode: true,
                            },
                        },
                    },
                });
                if (transaction?.recipient?.sms?.client) {
                    await this.webhookService.sendSMSStatusUpdateWebhook({
                        smsTransaction: transaction,
                        smsRecipient: transaction.recipient,
                        sms: transaction.recipient.sms,
                        shortCode: transaction.recipient.sms.shortCode,
                    }, transaction.recipient.sms.client);
                }
            }
            catch (error) {
                this.loggerDbService._create({
                    message: `Webhook notification failed: ${error?.message ?? error?.toString()}`,
                    refCat: base_enum_1.ELoggerRefCat.sendSMS,
                    refNo: transactionId,
                    orgID: transactionId,
                    isError: true,
                });
            }
        }
        return result;
    }
};
exports.SMSTransactionService = SMSTransactionService;
exports.SMSTransactionService = SMSTransactionService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [la_nest_library_1.SDKWalletTransactionService,
        sms_transaction_repository_1.SMSTransactionRepository,
        client_service_1.ClientService,
        la_nest_library_1.LoggerDBService,
        webhook_service_1.WebhookService])
], SMSTransactionService);
let SMSTransactionServiceModule = class SMSTransactionServiceModule {
};
exports.SMSTransactionServiceModule = SMSTransactionServiceModule;
exports.SMSTransactionServiceModule = SMSTransactionServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature([sms_transaction_entity_1.SMSTransactionEntity]), la_nest_library_1.SDKWalletModule],
        providers: [SMSTransactionService],
        exports: [SMSTransactionService],
    })
], SMSTransactionServiceModule);
//# sourceMappingURL=sms-transaction.service.js.map