import { ClientService } from '../partner/client.service';
import { SMSTransactionRepository } from '../../repositories/sms/sms-transaction.repository';
import { LoggerDBService, SDKWalletTransactionService } from '@serene-dev/la-nest-library';
import { SMSEntity } from '../../entities/sms/sms.entity';
import { ESMSResponseCode } from '../../enums/sms/sms.enum';
import { PartnerEntity } from '../../entities/partner.entity';
import { WalletBalanceView } from '@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.entity';
import { SMSTransactionEntity } from '../../entities/sms/sms-transaction.entity';
import { SendSMSConfig } from '../../dtos/sms.dto';
import { WebhookService } from '../webhook/webhook.service';
export declare class SMSTransactionService {
    protected walletTransactionService: SDKWalletTransactionService;
    smsTransactionRepository: SMSTransactionRepository;
    protected clientService: ClientService;
    protected loggerDbService: LoggerDBService;
    protected webhookService: WebhookService;
    protected readonly walletTransRefCat = "SMS_TRANSACTION";
    constructor(walletTransactionService: SDKWalletTransactionService, smsTransactionRepository: SMSTransactionRepository, clientService: ClientService, loggerDbService: LoggerDBService, webhookService: WebhookService);
    protected amountExtractor: (data: SMSEntity) => Promise<{
        wallet: WalletBalanceView | null;
        amount: number;
        error?: ESMSResponseCode;
    }>;
    create(data: SMSEntity, provider: PartnerEntity, config?: SendSMSConfig): Promise<{
        error: ESMSResponseCode;
    }>;
    update(transactionId: string, update: Partial<SMSTransactionEntity>, sendWebhook?: boolean): Promise<import("typeorm").UpdateResult>;
}
export declare class SMSTransactionServiceModule {
}
