"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSProviderServiceModule = exports.SMSProviderService = void 0;
const common_1 = require("@nestjs/common");
const provider_service_1 = require("../../partner/provider.service");
const sms_recipient_repository_1 = require("../../../repositories/sms/sms-recipient.repository");
const sms_transaction_repository_1 = require("../../../repositories/sms/sms-transaction.repository");
const sms_repository_1 = require("../../../repositories/sms/sms.repository");
const briccs_provider_service_1 = require("./briccs-provider.service");
const rxjs_1 = require("rxjs");
const client_service_1 = require("../../partner/client.service");
const utility_service_1 = require("../../utility.service");
const hollatags_provider_service_1 = require("./hollatags-provider.service");
const monty_provider_service_1 = require("./monty-provider.service");
const sms_enum_1 = require("../../../enums/sms/sms.enum");
const provider_enum_1 = require("../../../enums/provider.enum");
const typeorm_1 = require("@nestjs/typeorm");
let SMSProviderService = class SMSProviderService {
    constructor(providerService, briccsService, hollaTagsService, montyService, smsRepository, smsTransactionRepository, smsRecipienRepository, clientService) {
        this.providerService = providerService;
        this.briccsService = briccsService;
        this.hollaTagsService = hollaTagsService;
        this.montyService = montyService;
        this.smsRepository = smsRepository;
        this.smsTransactionRepository = smsTransactionRepository;
        this.smsRecipienRepository = smsRecipienRepository;
        this.clientService = clientService;
        this.providers = [];
        this.queue = {};
        this.providerToService = {
            [provider_enum_1.EProvider.briccs]: this.briccsService,
            [provider_enum_1.EProvider.hollatags]: this.hollaTagsService,
            [provider_enum_1.EProvider.monty]: this.montyService,
        };
        this.providerService.recalculateProviders.pipe((0, rxjs_1.switchMap)(() => this.recalculateProviders()));
    }
    async recalculateProviders() {
        const providers = await this.providerService.repo.find({
            where: { active: true },
            order: { priority: 'DESC' },
        });
        this.providers = providers;
    }
    async pickProvider(sms, config) {
        const client = await this.clientService.repo.findOne({
            where: { id: sms.clientId },
            relations: {
                currentPromotionalProduct: { group: true },
                currentTransactionalProduct: { group: true },
            },
            select: {
                currentPromotionalProduct: {
                    id: true,
                    group: { id: true, providerCode: true },
                },
                currentTransactionalProduct: {
                    id: true,
                    group: { id: true, providerCode: true },
                },
            },
        });
        if (config?.provider)
            return this.providerToService[config?.provider];
        if (sms.type == sms_enum_1.ESMSType.promotional)
            if (!client.currentPromotionalProduct)
                utility_service_1.UtilityClass.throwError({
                    message: `You do not have a promotional account. Kindly pay for one.`,
                });
            else if (client.currentPromotionalProduct.group?.providerCode == provider_enum_1.EProvider.briccs)
                return this.briccsService;
            else if (client.currentPromotionalProduct.group?.providerCode ==
                provider_enum_1.EProvider.hollatags)
                return this.hollaTagsService;
            else if (client.currentPromotionalProduct.group?.providerCode == provider_enum_1.EProvider.monty)
                return this.montyService;
            else
                utility_service_1.UtilityClass.throwError({
                    message: `Handler could not be determined for your account`,
                });
        else if (!client.currentTransactionalProduct)
            utility_service_1.UtilityClass.throwError({
                message: `You do not have a transactional account. Kindly pay for one.`,
            });
        else if (client.currentTransactionalProduct?.group?.providerCode ==
            provider_enum_1.EProvider.briccs)
            return this.briccsService;
        else if (client.currentTransactionalProduct?.group?.providerCode ==
            provider_enum_1.EProvider.hollatags)
            return this.hollaTagsService;
        else if (client.currentTransactionalProduct?.group?.providerCode == provider_enum_1.EProvider.monty)
            return this.montyService;
        else
            utility_service_1.UtilityClass.throwError({
                message: `Handler could not be determined for your account`,
            });
    }
    async send(data, config) {
        return (await this.pickProvider(data, config)).send(data, config);
    }
    async sendBulk(client, data) {
        return (await Promise.all(data.map((d) => this.send({ ...d, client })))).flatMap((r) => r);
    }
};
exports.SMSProviderService = SMSProviderService;
exports.SMSProviderService = SMSProviderService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [provider_service_1.ProviderService,
        briccs_provider_service_1.BriccsProviderService,
        hollatags_provider_service_1.HollaTagsProviderService,
        monty_provider_service_1.MontyProviderService,
        sms_repository_1.SMSRepository,
        sms_transaction_repository_1.SMSTransactionRepository,
        sms_recipient_repository_1.SMSRecipienRepository,
        client_service_1.ClientService])
], SMSProviderService);
let SMSProviderServiceModule = class SMSProviderServiceModule {
};
exports.SMSProviderServiceModule = SMSProviderServiceModule;
exports.SMSProviderServiceModule = SMSProviderServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature([])],
        providers: [SMSProviderService],
        exports: [SMSProviderService],
    })
], SMSProviderServiceModule);
//# sourceMappingURL=sms-provider.service.js.map