import { ProviderService } from 'src/services/partner/provider.service';
import { PartnerEntity } from '../../../entities/partner.entity';
import { SMSRecipienRepository } from '../../../repositories/sms/sms-recipient.repository';
import { SMSTransactionRepository } from '../../../repositories/sms/sms-transaction.repository';
import { SMSRepository } from '../../../repositories/sms/sms.repository';
import { SMSEntity } from '../../../entities/sms/sms.entity';
import { BriccsProviderService } from './briccs-provider.service';
import { SendSMSConfig, SendSMSResponseDto } from '../../../dtos/sms.dto';
import { SMSProviderBaseService } from './sms-provider.base.service';
import { ClientService } from '../../partner/client.service';
import { HollaTagsProviderService } from './hollatags-provider.service';
import { MontyProviderService } from './monty-provider.service';
import { EProvider } from '../../../enums/provider.enum';
export declare class SMSProviderService {
    protected providerService: ProviderService;
    protected briccsService: BriccsProviderService;
    protected hollaTagsService: HollaTagsProviderService;
    protected montyService: MontyProviderService;
    protected smsRepository: SMSRepository;
    protected smsTransactionRepository: SMSTransactionRepository;
    protected smsRecipienRepository: SMSRecipienRepository;
    protected clientService: ClientService;
    protected providers: PartnerEntity[];
    protected queue: {
        [clientID: string]: SMSEntity[];
    };
    protected readonly providerToService: Record<EProvider, SMSProviderBaseService>;
    constructor(providerService: ProviderService, briccsService: BriccsProviderService, hollaTagsService: HollaTagsProviderService, montyService: MontyProviderService, smsRepository: SMSRepository, smsTransactionRepository: SMSTransactionRepository, smsRecipienRepository: SMSRecipienRepository, clientService: ClientService);
    protected recalculateProviders(): Promise<void>;
    protected pickProvider(sms: SMSEntity, config?: SendSMSConfig): Promise<SMSProviderBaseService>;
    send(data: SMSEntity, config?: SendSMSConfig): Promise<SendSMSResponseDto[]>;
    sendBulk(client: PartnerEntity, data: SMSEntity[]): Promise<SendSMSResponseDto[]>;
}
export declare class SMSProviderServiceModule {
}
