"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSProviderBaseService = void 0;
const common_1 = require("@nestjs/common");
const provider_service_1 = require("../../partner/provider.service");
const sms_recipient_repository_1 = require("../../../repositories/sms/sms-recipient.repository");
const sms_repository_1 = require("../../../repositories/sms/sms.repository");
const provider_enum_1 = require("../../../enums/provider.enum");
const utility_service_1 = require("../../utility.service");
const rxjs_1 = require("rxjs");
const core_1 = require("@nestjs/core");
const short_code_service_1 = require("../../short-code/short-code.service");
const client_service_1 = require("../../partner/client.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const sms_transaction_service_1 = require("../sms-transaction.service");
const toad_scheduler_1 = require("toad-scheduler");
const sms_enum_1 = require("../../../enums/sms/sms.enum");
const environment_service_1 = require("../../environment.service");
const schedule_1 = require("@nestjs/schedule");
const typeorm_1 = require("typeorm");
let SMSProviderBaseService = class SMSProviderBaseService {
    constructor(key, moduleRef) {
        this.key = key;
        this.moduleRef = moduleRef;
        this.periodicalScheduler = new toad_scheduler_1.ToadScheduler();
        this.recipientUpdaterAfterTrans = (update) => (recipient, index) => {
            const _update = update(recipient, index);
            return this.smsTransactionService
                .update(recipient.transaction?.id, _update)
                .then(() => (recipient.transaction = {
                ...recipient.transaction,
                ..._update,
            }));
        };
        this.sender = async (data) => {
            data;
            utility_service_1.UtilityClass.throwError({
                message: `No handler for ${this.key || 'provider'}`,
            });
        };
        this.senderBulk = async (data) => {
            return await Promise.all(data.map((d) => (d.hasError ? d.sms : this.sender(d.sms))));
        };
        this.numberJoiner = (sms) => sms.recipients
            .filter((r) => !r.transaction?.error)
            .map((r) => r.recipient)
            .join(',');
    }
    onModuleInit() {
        this.providerService.recalculateProviders
            .pipe((0, rxjs_1.switchMap)(() => this.fetchProvider()))
            .subscribe();
    }
    get cantRunRealTimeCheck() {
        return environment_service_1.evt.NO_DB_STUFF;
    }
    async fetchProvider() {
        this.provider = await this.providerService.getSingle({
            providerCode: this.key,
        });
    }
    async handleWrongShortCode(data) {
        await Promise.all(data.recipients.map(await this.recipientUpdaterAfterTrans(() => ({
            dateTimeFailed: Date.now(),
            status: sms_enum_1.ESMSStatus.failed,
            error: sms_enum_1.ESMSResponseCode.invalidSenderId,
            resolvedFeedback: true,
        }))));
    }
    async send(data, config) {
        const { error } = await this.smsTransactionService.create(data, this.provider, config);
        return this.smsResponseFormatter([error ? data : await this.sender(data)]);
    }
    async sendBulk(data) {
        const errorMap = {};
        await Promise.all(data.map(async (s) => {
            const { error } = await this.smsTransactionService.create(s, this.provider);
            if (error)
                errorMap[s.id] = true;
        }));
        return this.smsResponseFormatter(await this.senderBulk(data.map((sms) => ({ sms, hasError: errorMap[sms.id] }))));
    }
    smsResponseFormatter(smses) {
        return smses.flatMap((sms) => sms.recipients.map((r) => ({
            reference: r.transaction.id,
            transactionId: r.transaction.id,
            messageId: sms.id,
            status: r.transaction.status,
            error: r.transaction.error,
        })));
    }
    async reconcileMessageStatuses() {
        return this._reconcileMessageStatuses();
    }
    async _reconcileMessageStatuses() {
        if (!this.reconciliationHandler)
            return;
        const subject = `Reconcile message statuses for ${this.key}`;
        try {
            la_nest_library_1.logger.info(subject);
            const transactions = await this.smsTransactionService.smsTransactionRepository.find({
                where: {
                    resolvedFeedback: false,
                    pMessageID: (0, typeorm_1.Not)((0, typeorm_1.IsNull)()),
                    provider: { providerCode: this.key },
                },
                select: { recipient: { id: true, sms: { type: true, id: true } } },
                relations: { recipient: { sms: true } },
            });
            const result = transactions.length
                ? await (0, rxjs_1.lastValueFrom)((0, rxjs_1.concat)(...transactions.map((t) => new rxjs_1.Observable((sub) => {
                    this.reconciliationHandler(t)
                        .then((r) => this.smsTransactionService
                        .update(t.id, r)
                        .then(() => r))
                        .catch((e) => e)
                        .then((r) => {
                        la_nest_library_1.logger.info(subject + ' ' + t.id, r);
                        sub.next(t.id);
                        sub.complete();
                    });
                })))).then(() => ({
                    message: `Updated transactions count: ${transactions.length} at ${new Date().toISOString()} or ${Date.now()}`,
                }))
                : { message: `No transactions to reconcile status` };
            la_nest_library_1.logger.info({ subject: subject + ' completed', result });
        }
        catch (error) {
            la_nest_library_1.logger.error({ subject, error });
            la_nest_library_1.MailService.sendToAdmin({
                subject,
                text: typeof error == 'string' ? error : JSON.stringify(error),
            });
        }
    }
};
exports.SMSProviderBaseService = SMSProviderBaseService;
__decorate([
    (0, common_1.Inject)(),
    __metadata("design:type", provider_service_1.ProviderService)
], SMSProviderBaseService.prototype, "providerService", void 0);
__decorate([
    (0, common_1.Inject)(),
    __metadata("design:type", sms_repository_1.SMSRepository)
], SMSProviderBaseService.prototype, "smsRepository", void 0);
__decorate([
    (0, common_1.Inject)(),
    __metadata("design:type", sms_transaction_service_1.SMSTransactionService)
], SMSProviderBaseService.prototype, "smsTransactionService", void 0);
__decorate([
    (0, common_1.Inject)(),
    __metadata("design:type", sms_recipient_repository_1.SMSRecipienRepository)
], SMSProviderBaseService.prototype, "smsRecipienRepository", void 0);
__decorate([
    (0, common_1.Inject)(),
    __metadata("design:type", short_code_service_1.ShortCodeService)
], SMSProviderBaseService.prototype, "shortCodeService", void 0);
__decorate([
    (0, common_1.Inject)(),
    __metadata("design:type", la_nest_library_1.LoggerDBService)
], SMSProviderBaseService.prototype, "loggerDbService", void 0);
__decorate([
    (0, common_1.Inject)(),
    __metadata("design:type", client_service_1.ClientService)
], SMSProviderBaseService.prototype, "clientService", void 0);
__decorate([
    (0, schedule_1.Cron)(schedule_1.CronExpression.EVERY_5_MINUTES, { waitForCompletion: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SMSProviderBaseService.prototype, "_reconcileMessageStatuses", null);
exports.SMSProviderBaseService = SMSProviderBaseService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [String, core_1.ModuleRef])
], SMSProviderBaseService);
//# sourceMappingURL=sms-provider.base.service.js.map