import { OnModuleInit } from '@nestjs/common';
import { ProviderService } from 'src/services/partner/provider.service';
import { PartnerEntity } from '../../../entities/partner.entity';
import { SMSRecipienRepository } from '../../../repositories/sms/sms-recipient.repository';
import { SMSRepository } from '../../../repositories/sms/sms.repository';
import { EProvider } from '../../../enums/provider.enum';
import { SMSEntity } from '../../../entities/sms/sms.entity';
import { SendSMSConfig, SendSMSResponseDto } from '../../../dtos/sms.dto';
import { ModuleRef } from '@nestjs/core';
import { ShortCodeService } from '../../short-code/short-code.service';
import { ClientService } from '../../partner/client.service';
import { LoggerDBService } from '@serene-dev/la-nest-library';
import { SMSTransactionService } from '../sms-transaction.service';
import { SimpleIntervalJob, ToadScheduler } from 'toad-scheduler';
import { ESMSResponseCode, ESMSStatus } from 'src/enums/sms/sms.enum';
import { SMSRecipientEntity } from 'src/entities/sms/sms-recipient.entity';
import { SMSTransactionEntity } from 'src/entities/sms/sms-transaction.entity';
export declare abstract class SMSProviderBaseService implements OnModuleInit {
    protected readonly key: EProvider;
    protected moduleRef: ModuleRef;
    provider: PartnerEntity;
    protected providerService: ProviderService;
    protected smsRepository: SMSRepository;
    protected smsTransactionService: SMSTransactionService;
    protected smsRecipienRepository: SMSRecipienRepository;
    protected shortCodeService: ShortCodeService;
    protected loggerDbService: LoggerDBService;
    protected clientService: ClientService;
    protected realTimeJob: SimpleIntervalJob;
    protected readonly periodicalScheduler: ToadScheduler;
    constructor(key: EProvider, moduleRef: ModuleRef);
    onModuleInit(): void;
    protected get cantRunRealTimeCheck(): boolean;
    protected fetchProvider(): Promise<void>;
    protected recipientUpdaterAfterTrans: (update: (recipient: SMSRecipientEntity, index: number) => Partial<SMSTransactionEntity>) => (recipient: SMSRecipientEntity, index: number) => Promise<{
        recipient: import("typeorm").Relation<SMSRecipientEntity>;
        recipientId?: string;
        walletTransaction: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKWalletTransaction>;
        walletTransactionId?: string;
        amount: number;
        status: ESMSStatus;
        error?: ESMSResponseCode;
        dateTimeDelivered?: number;
        dateTimeFailed?: number;
        dateTimeSent?: number;
        pMessageID?: string;
        pErrorCode?: string;
        pErrorMessage?: string;
        resolvedFeedback: boolean;
        provider: import("typeorm").Relation<PartnerEntity>;
        providerId?: string;
        webhooks?: import("typeorm").Relation<import("../../../entities/webhook.entity").WebhookEntity[]>;
        lastUpdateID?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
        id?: string;
    }>;
    protected handleWrongShortCode(data: SMSEntity): Promise<void>;
    sender: (data: SMSEntity) => Promise<SMSEntity>;
    protected senderBulk: (data: {
        sms: SMSEntity;
        hasError: boolean;
    }[]) => Promise<SMSEntity[]>;
    send(data: SMSEntity, config?: SendSMSConfig): Promise<SendSMSResponseDto[]>;
    sendBulk(data: SMSEntity[]): Promise<SendSMSResponseDto[]>;
    protected smsResponseFormatter(smses: SMSEntity[]): SendSMSResponseDto[];
    protected numberJoiner: (sms: SMSEntity) => string;
    reconcileMessageStatuses(): Promise<void>;
    reconciliationHandler: (t: SMSTransactionEntity) => Promise<Pick<SMSTransactionEntity, 'resolvedFeedback' | 'dateTimeDelivered' | 'dateTimeFailed' | 'status' | 'pErrorCode' | 'pErrorMessage' | 'error'>>;
    private _reconcileMessageStatuses;
}
