"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MontyProviderModule = exports.MontyProviderService = exports.ESMSMontyError = void 0;
const common_1 = require("@nestjs/common");
const provider_enum_1 = require("../../../enums/provider.enum");
const sms_provider_base_service_1 = require("./sms-provider.base.service");
const environment_service_1 = require("../../environment.service");
const sms_enum_1 = require("../../../enums/sms/sms.enum");
const api_service_1 = require("../../api.service");
const core_1 = require("@nestjs/core");
const axios_1 = require("@nestjs/axios");
const axios_2 = require("axios");
const sms_monty_enum_1 = require("../../../enums/sms/sms.monty.enum");
const base_enum_1 = require("../../../enums/base.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
var ESMSMontyError;
(function (ESMSMontyError) {
    ESMSMontyError[ESMSMontyError["Ok"] = 0] = "Ok";
    ESMSMontyError[ESMSMontyError["NoMessage"] = 1] = "NoMessage";
    ESMSMontyError[ESMSMontyError["NoSource"] = 2] = "NoSource";
    ESMSMontyError[ESMSMontyError["NoDestination"] = 3] = "NoDestination";
    ESMSMontyError[ESMSMontyError["UnsupportedDestination"] = 4] = "UnsupportedDestination";
    ESMSMontyError[ESMSMontyError["InvalidCredentials"] = 5] = "InvalidCredentials";
    ESMSMontyError[ESMSMontyError["NoCredit"] = 6] = "NoCredit";
    ESMSMontyError[ESMSMontyError["InvalidDataCoding"] = 7] = "InvalidDataCoding";
    ESMSMontyError[ESMSMontyError["IPNotWhiteListed"] = 8] = "IPNotWhiteListed";
    ESMSMontyError[ESMSMontyError["UnknownError"] = 10] = "UnknownError";
    ESMSMontyError[ESMSMontyError["InvalidInstanceConnection"] = 11] = "InvalidInstanceConnection";
    ESMSMontyError[ESMSMontyError["InvalidDestination"] = 12] = "InvalidDestination";
})(ESMSMontyError || (exports.ESMSMontyError = ESMSMontyError = {}));
let MontyProviderService = class MontyProviderService extends sms_provider_base_service_1.SMSProviderBaseService {
    constructor(apiS, moduleRef) {
        super(provider_enum_1.EProvider.monty, moduleRef);
        this.apiS = apiS;
        this.moduleRef = moduleRef;
        this.errorMap = {
            [ESMSMontyError.Ok]: sms_enum_1.ESMSResponseCode.sent,
            [ESMSMontyError.InvalidCredentials]: sms_enum_1.ESMSResponseCode.internalError,
            [ESMSMontyError.NoCredit]: sms_enum_1.ESMSResponseCode.internalError,
            [ESMSMontyError.InvalidDataCoding]: sms_enum_1.ESMSResponseCode.internalError,
            [ESMSMontyError.IPNotWhiteListed]: sms_enum_1.ESMSResponseCode.internalError,
            [ESMSMontyError.UnknownError]: sms_enum_1.ESMSResponseCode.internalError,
            [ESMSMontyError.InvalidInstanceConnection]: sms_enum_1.ESMSResponseCode.internalError,
            [ESMSMontyError.NoMessage]: sms_enum_1.ESMSResponseCode.payloadError,
            [ESMSMontyError.NoSource]: sms_enum_1.ESMSResponseCode.payloadError,
            [ESMSMontyError.NoDestination]: sms_enum_1.ESMSResponseCode.payloadError,
            [ESMSMontyError.UnsupportedDestination]: sms_enum_1.ESMSResponseCode.unsupportedMobileNumbers,
            [ESMSMontyError.InvalidDestination]: sms_enum_1.ESMSResponseCode.invalidMobileNumbers,
        };
        this.headerSelector = (type) => {
            return new axios_2.AxiosHeaders({
                Username: this.config[type]?.username,
                Password: this.config[type]?.password,
            });
        };
        setTimeout(() => {
            this.host = environment_service_1.evt.MONTY_HOST;
            this.config = {
                [sms_enum_1.ESMSType.promotional]: {
                    username: environment_service_1.evt.MONTY_USERNAME,
                    password: environment_service_1.evt.MONTY_PASSWORD,
                },
                [sms_enum_1.ESMSType.transactional]: {
                    username: environment_service_1.evt.MONTY_USERNAME,
                    password: environment_service_1.evt.MONTY_PASSWORD,
                },
            };
        }, 300);
        this.sender = async (data) => {
            if (!data.shortCode?.code) {
                await this.handleWrongShortCode(data);
                return data;
            }
            const config = this.config[data.type];
            const dateTimeSent = Date.now();
            data.recipients?.forEach((r) => {
                r.recipient = r.recipient.replace('+234', '0');
            });
            const reqPayload = {
                source: data.shortCode.code,
                text: data.message,
                destination: this.numberJoiner(data),
                messageId: data.id,
            };
            const res = await this.apiS.post(this.host + 'Client/SendSMS', reqPayload, {
                axiosConfig: {
                    headers: this.headerSelector(data.type),
                },
            });
            if (res.ErrorCode !== 0) {
                await Promise.all(data.recipients.map(await this.recipientUpdaterAfterTrans((_, i) => ({
                    dateTimeSent,
                    dateTimeFailed: Date.now(),
                    status: sms_enum_1.ESMSStatus.failed,
                    pErrorCode: res.ErrorCode + '',
                    pErrorMessage: res.ErrorDescription,
                    error: sms_enum_1.ESMSResponseCode.internalError,
                    pMessageID: res.SMS[i]?.Id,
                    resolvedFeedback: true,
                }))));
            }
            else {
                await Promise.all(data.recipients.map(await this.recipientUpdaterAfterTrans((r) => {
                    const resData = res.SMS.find((x) => x.DestinationAddress === r.recipient);
                    const transUpdate = resData?.ErrorCode == ESMSMontyError.Ok
                        ? {
                            dateTimeSent: Date.now(),
                            status: sms_enum_1.ESMSStatus.sent,
                        }
                        : {
                            dateTimeFailed: Date.now(),
                            status: sms_enum_1.ESMSStatus.failed,
                            pErrorCode: resData.ErrorCode + '',
                            error: this.errorMap[resData.ErrorCode],
                        };
                    return {
                        dateTimeSent,
                        pMessageID: resData?.Id,
                        ...transUpdate,
                    };
                })));
            }
            return data;
        };
    }
    async callback(_data) {
        la_nest_library_1.logger.info(_data, 'monty callback');
        if (!_data)
            return null;
        if (!_data?.CallBackResponse?.MessageId)
            return null;
        const data = _data.CallBackResponse;
        const smses = await this.smsTransactionService.smsTransactionRepository.find({
            where: { pMessageID: data.MessageId },
            select: {
                id: true,
                status: true,
                pErrorCode: true,
                pErrorMessage: true,
                recipient: {
                    id: true,
                    recipient: true,
                },
            },
            relations: {
                recipient: true,
            },
        });
        if (!smses?.length) {
            this.loggerDbService._create({
                refCat: base_enum_1.ELoggerRefCat.smsCallback,
                message: JSON.stringify({
                    data,
                    message: 'No transactions found',
                }),
            });
            return null;
        }
        this.loggerDbService._create({
            refCat: base_enum_1.ELoggerRefCat.smsCallback,
            message: JSON.stringify({ data }),
        });
        const doneDate = Date.now();
        const isDelivered = data.StatusId === sms_monty_enum_1.ESMSMontyStatusId.delivered;
        const isFailed = data.StatusId === sms_monty_enum_1.ESMSMontyStatusId.expired ||
            data.StatusId === sms_monty_enum_1.ESMSMontyStatusId.deleted ||
            data.StatusId === sms_monty_enum_1.ESMSMontyStatusId.undelivered ||
            data.StatusId === sms_monty_enum_1.ESMSMontyStatusId.invalid ||
            data.StatusId === sms_monty_enum_1.ESMSMontyStatusId.rejected;
        await Promise.all(smses.map((t) => this.smsTransactionService.update(t.id, {
            resolvedFeedback: true,
            dateTimeDelivered: isDelivered ? doneDate : null,
            dateTimeFailed: isFailed ? doneDate : null,
            status: isDelivered
                ? sms_enum_1.ESMSStatus.delivered
                : isFailed
                    ? sms_enum_1.ESMSStatus.failed
                    : data.StatusId === sms_monty_enum_1.ESMSMontyStatusId.accepted
                        ? sms_enum_1.ESMSStatus.sent
                        : t.status,
            pErrorCode: data.err ? data.err : t.pErrorCode,
            pErrorMessage: data.err || t.pErrorMessage,
            error: data.err
                ? this.errorMap[parseInt(data.err)] ||
                    sms_enum_1.ESMSResponseCode.internalError
                : null,
        })));
    }
};
exports.MontyProviderService = MontyProviderService;
exports.MontyProviderService = MontyProviderService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [api_service_1.APIService,
        core_1.ModuleRef])
], MontyProviderService);
let MontyProviderModule = class MontyProviderModule {
};
exports.MontyProviderModule = MontyProviderModule;
exports.MontyProviderModule = MontyProviderModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        providers: [MontyProviderService, api_service_1.APIService],
        imports: [axios_1.HttpModule],
        exports: [MontyProviderService],
    })
], MontyProviderModule);
//# sourceMappingURL=monty-provider.service.js.map