import { SMSProviderBaseService } from './sms-provider.base.service';
import { ESMSResponseCode, ESMSType } from '../../../enums/sms/sms.enum';
import { APIService } from '../../api.service';
import { ModuleRef } from '@nestjs/core';
import { AxiosRequestConfig } from 'axios';
import { MontyCallbackDto } from '../../../dtos/monty.dto';
export declare enum ESMSMontyError {
    Ok = 0,
    NoMessage = 1,
    NoSource = 2,
    NoDestination = 3,
    UnsupportedDestination = 4,
    InvalidCredentials = 5,
    NoCredit = 6,
    InvalidDataCoding = 7,
    IPNotWhiteListed = 8,
    UnknownError = 10,
    InvalidInstanceConnection = 11,
    InvalidDestination = 12
}
export declare class MontyProviderService extends SMSProviderBaseService {
    protected apiS: APIService;
    protected moduleRef: ModuleRef;
    protected config: {
        [t in ESMSType]: {
            username: string;
            password: string;
        };
    };
    protected errorMap: {
        [k in ESMSMontyError]: ESMSResponseCode;
    };
    protected host: string;
    constructor(apiS: APIService, moduleRef: ModuleRef);
    protected headerSelector: (type: ESMSType) => AxiosRequestConfig["headers"];
    callback(_data: MontyCallbackDto): Promise<any>;
}
export declare class MontyProviderModule {
}
