"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HollaTagsProviderServiceModule = exports.HollaTagsProviderService = void 0;
const common_1 = require("@nestjs/common");
const provider_enum_1 = require("../../../enums/provider.enum");
const sms_provider_base_service_1 = require("./sms-provider.base.service");
const environment_service_1 = require("../../environment.service");
const sms_enum_1 = require("../../../enums/sms/sms.enum");
const api_service_1 = require("../../api.service");
const core_1 = require("@nestjs/core");
const sms_hollatags_enum_1 = require("../../../enums/sms/sms.hollatags.enum");
const utility_service_1 = require("../../utility.service");
const base_enum_1 = require("../../../enums/base.enum");
const qs = require("querystring");
const typeorm_1 = require("@nestjs/typeorm");
let HollaTagsProviderService = class HollaTagsProviderService extends sms_provider_base_service_1.SMSProviderBaseService {
    constructor(apiS, moduleRef) {
        super(provider_enum_1.EProvider.hollatags, moduleRef);
        this.apiS = apiS;
        this.moduleRef = moduleRef;
        this.errorMap = {
            [sms_hollatags_enum_1.ESMSHollaTagsError.sent]: sms_enum_1.ESMSResponseCode.sent,
            [sms_hollatags_enum_1.ESMSHollaTagsError.error_param]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_hollatags_enum_1.ESMSHollaTagsError.error_credit]: sms_enum_1.ESMSResponseCode.insufficientBalance,
            [sms_hollatags_enum_1.ESMSHollaTagsError.error_billing]: sms_enum_1.ESMSResponseCode.insufficientBalance,
            [sms_hollatags_enum_1.ESMSHollaTagsError.error_gw]: sms_enum_1.ESMSResponseCode.gatewayError,
            [sms_hollatags_enum_1.ESMSHollaTagsError.error_user]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_hollatags_enum_1.ESMSHollaTagsError.error_limit]: sms_enum_1.ESMSResponseCode.internalError,
        };
        setTimeout(() => {
            this.host = environment_service_1.evt.HOLLATAGS_HOST;
            this.config = {
                [sms_enum_1.ESMSType.promotional]: {
                    user: environment_service_1.evt.HOLLATAGS_USER,
                    pass: environment_service_1.evt.HOLLATAGS_PWD,
                },
                [sms_enum_1.ESMSType.transactional]: {
                    user: environment_service_1.evt.HOLLATAGS_USER,
                    pass: environment_service_1.evt.HOLLATAGS_PWD,
                },
            };
        }, 300);
        this.sender = async (data) => {
            if (!data.shortCode?.code)
                return data;
            const config = this.config[data.type];
            const dateTimeSent = Date.now();
            const reqPayload = {
                ...config,
                from: data.shortCode.code,
                to: this.numberJoiner(data),
                msg: data.message,
                type: sms_hollatags_enum_1.ESMSHollaTagsMessageFormat.normalSms,
                callback_url: `${utility_service_1.UtilityClass.getServerURL()}/hollatags/callback/${data.id}`,
                enable_msg_id: true,
                message_uuid: data.id,
            };
            const res = await this.apiS.post(this.host + 'send', qs.stringify(reqPayload), {
                axiosConfig: {
                    headers: {
                        'content-type': 'application/x-www-form-urlencoded',
                    },
                },
            });
            if (!res)
                await Promise.all(data.recipients.map(await this.recipientUpdaterAfterTrans(() => ({
                    dateTimeSent,
                    dateTimeFailed: Date.now(),
                    status: sms_enum_1.ESMSStatus.failed,
                    resolvedFeedback: true,
                }))));
            else {
                const resFormatted = {};
                res.split('~').map((chunk) => {
                    const [recipient, pID] = chunk.split(',');
                    resFormatted[recipient] = pID;
                });
                await Promise.all(data.recipients.map(await this.recipientUpdaterAfterTrans((r, i) => {
                    const pMessageID = resFormatted[r.recipient];
                    const transUpdate = pMessageID
                        ? {
                            dateTimeSent: Date.now(),
                            status: sms_enum_1.ESMSStatus.sent,
                            pMessageID,
                        }
                        : {};
                    return {
                        dateTimeSent,
                        ...transUpdate,
                    };
                })));
            }
            return data;
        };
        this.reconciliationHandler = (t) => {
            const config = this.config[t.recipient.sms.type];
            return this.apiS
                .post(this.host + 'report', qs.stringify({
                ...config,
                msgid: t.pMessageID,
            }), {
                axiosConfig: {
                    headers: {
                        'content-type': 'application/x-www-form-urlencoded',
                    },
                },
            })
                .then(async (r) => {
                const doneDate = new Date().getTime();
                return {
                    resolvedFeedback: true,
                    dateTimeDelivered: r == sms_hollatags_enum_1.ESMSHollaTagsStatus.delivered ? doneDate : null,
                    dateTimeFailed: r == sms_hollatags_enum_1.ESMSHollaTagsStatus.expired ||
                        r == sms_hollatags_enum_1.ESMSHollaTagsStatus.undelivered
                        ? doneDate
                        : null,
                    status: r == sms_hollatags_enum_1.ESMSHollaTagsStatus.delivered
                        ? sms_enum_1.ESMSStatus.delivered
                        : r == sms_hollatags_enum_1.ESMSHollaTagsStatus.expired ||
                            r == sms_hollatags_enum_1.ESMSHollaTagsStatus.undelivered
                            ? sms_enum_1.ESMSStatus.failed
                            : t.status,
                };
            });
        };
    }
    async callback(data, smsId) {
        if (!smsId || !data)
            return null;
        const smses = await this.smsTransactionService.smsTransactionRepository.find({
            where: { recipient: { smsId } },
            select: {
                id: true,
                status: true,
                pErrorCode: true,
                pErrorMessage: true,
            },
        });
        if (!smses?.length)
            return null;
        this.loggerDbService._create({
            refCat: base_enum_1.ELoggerRefCat.smsCallback,
            message: JSON.stringify({ data, smsId }),
            refNo: smsId,
        });
        const doneDate = new Date(data?.done_date).getTime();
        await Promise.all(smses.map((t) => this.smsTransactionService.update(t.id, {
            resolvedFeedback: true,
            dateTimeDelivered: data.status == sms_hollatags_enum_1.ESMSHollaTagsStatus.delivered ? doneDate : null,
            dateTimeFailed: data.status == sms_hollatags_enum_1.ESMSHollaTagsStatus.undelivered ? doneDate : null,
            status: data.status == sms_hollatags_enum_1.ESMSHollaTagsStatus.delivered
                ? sms_enum_1.ESMSStatus.delivered
                : data.status == sms_hollatags_enum_1.ESMSHollaTagsStatus.undelivered ||
                    data.status == sms_hollatags_enum_1.ESMSHollaTagsStatus.expired
                    ? sms_enum_1.ESMSStatus.failed
                    : t.status,
            pErrorCode: data.status_code != '000' ? data.status_code + '' : t.pErrorCode,
            error: data.status_code != '000' ? this.errorMap[data.status_code] : null,
        })));
    }
    getCredit() {
        return Promise.all(Object.values(this.config).map((value) => this.apiS.post(this.host + 'credit', qs.stringify(value), {
            axiosConfig: {
                headers: {
                    'content-type': 'application/x-www-form-urlencoded',
                },
            },
        })));
    }
};
exports.HollaTagsProviderService = HollaTagsProviderService;
exports.HollaTagsProviderService = HollaTagsProviderService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [api_service_1.APIService,
        core_1.ModuleRef])
], HollaTagsProviderService);
let HollaTagsProviderServiceModule = class HollaTagsProviderServiceModule {
};
exports.HollaTagsProviderServiceModule = HollaTagsProviderServiceModule;
exports.HollaTagsProviderServiceModule = HollaTagsProviderServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature([])],
        providers: [HollaTagsProviderService],
        exports: [HollaTagsProviderService],
    })
], HollaTagsProviderServiceModule);
//# sourceMappingURL=hollatags-provider.service.js.map