import { SMSProviderBaseService } from './sms-provider.base.service';
import { ESMSResponseCode, ESMSType } from '../../../enums/sms/sms.enum';
import { APIService } from '../../api.service';
import { ModuleRef } from '@nestjs/core';
import { ESMSHollaTagsError } from '../../../enums/sms/sms.hollatags.enum';
import { HollaTagsCallbackDto } from '../../../dtos/hollatags.dto';
export declare class HollaTagsProviderService extends SMSProviderBaseService {
    protected apiS: APIService;
    protected moduleRef: ModuleRef;
    protected config: Record<ESMSType, {
        user: string;
        pass: string;
    }>;
    protected errorMap: Record<ESMSHollaTagsError, ESMSResponseCode>;
    protected host: string;
    constructor(apiS: APIService, moduleRef: ModuleRef);
    callback(data: HollaTagsCallbackDto, smsId: string): Promise<any>;
    getCredit(): Promise<any[]>;
}
export declare class HollaTagsProviderServiceModule {
}
