"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BriccsProviderServiceModule = exports.BriccsProviderService = void 0;
const common_1 = require("@nestjs/common");
const provider_enum_1 = require("../../../enums/provider.enum");
const sms_provider_base_service_1 = require("./sms-provider.base.service");
const environment_service_1 = require("../../environment.service");
const sms_enum_1 = require("../../../enums/sms/sms.enum");
const api_service_1 = require("../../api.service");
const core_1 = require("@nestjs/core");
const sms_briccs_enum_1 = require("../../../enums/sms/sms.briccs.enum");
const typeorm_1 = require("@nestjs/typeorm");
let BriccsProviderService = class BriccsProviderService extends sms_provider_base_service_1.SMSProviderBaseService {
    constructor(apiS, moduleRef) {
        super(provider_enum_1.EProvider.briccs, moduleRef);
        this.apiS = apiS;
        this.moduleRef = moduleRef;
        this.errorMap = {
            [sms_briccs_enum_1.ESMSBriccsError.accountDetailsCannotBeBlank]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.usernameOrPasswordCannotBeBlank]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.senderIdCannotBeBlank]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.messageCannotBeBlank]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.messagePropertiesCannotBeBlank]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.serverErrorErrorMessage]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_briccs_enum_1.ESMSBriccsError.invalidUsernameOrPassword]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.accountInactive]: sms_enum_1.ESMSResponseCode.accountInactive,
            [sms_briccs_enum_1.ESMSBriccsError.accountLock]: sms_enum_1.ESMSResponseCode.accountLock,
            [sms_briccs_enum_1.ESMSBriccsError.unauthorizedApiAccess]: sms_enum_1.ESMSResponseCode.unauthorizedApiAccess,
            [sms_briccs_enum_1.ESMSBriccsError.unauthorizedIpAddress]: sms_enum_1.ESMSResponseCode.unauthorizedIpAddress,
            [sms_briccs_enum_1.ESMSBriccsError.messageLengthViolation]: sms_enum_1.ESMSResponseCode.messageLengthViolation,
            [sms_briccs_enum_1.ESMSBriccsError.invalidMobileNumbers]: sms_enum_1.ESMSResponseCode.invalidMobileNumbers,
            [sms_briccs_enum_1.ESMSBriccsError.accountLockedDueToSpamMessageContactSupport]: sms_enum_1.ESMSResponseCode.accountLockedDueToSpamMessageContactSupport,
            [sms_briccs_enum_1.ESMSBriccsError.invalidSednerId]: sms_enum_1.ESMSResponseCode.invalidSenderId,
            [sms_briccs_enum_1.ESMSBriccsError.transactionalAccountNotActive]: sms_enum_1.ESMSResponseCode.transactionalAccountNotActive,
            [sms_briccs_enum_1.ESMSBriccsError.invalidGroupid]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.cannotSendMultiMessageToGroup]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.invalidScheduleDate]: sms_enum_1.ESMSResponseCode.invalidScheduleDate,
            [sms_briccs_enum_1.ESMSBriccsError.messageOrMobileNumberCannotBeBlank]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.insufficientCredits]: sms_enum_1.ESMSResponseCode.insufficientBalance,
            [sms_briccs_enum_1.ESMSBriccsError.invalidJobid]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.parameterMissing]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.invalidTemplateOrTemplateMismatch]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.canNotBeBlankOrEmpty]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.invalidDateRange]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.alreadyExist]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.canNotBeFound]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.duplicate]: sms_enum_1.ESMSResponseCode.duplicate,
            [sms_briccs_enum_1.ESMSBriccsError.accountExpired]: sms_enum_1.ESMSResponseCode.accountExpired,
            [sms_briccs_enum_1.ESMSBriccsError.noGatewayIsAssigned]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.parentGroupDoesnTExist]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.queueConnectionClosed]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_briccs_enum_1.ESMSBriccsError.unableToCreateCampaignAtThisTimePleaseTryAgainLater]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_briccs_enum_1.ESMSBriccsError.spamMessage]: sms_enum_1.ESMSResponseCode.spamMessage,
            [sms_briccs_enum_1.ESMSBriccsError.errorWhilePublishingDlr]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_briccs_enum_1.ESMSBriccsError.reportNotFound]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.messageFailedDueToLossProtection]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_briccs_enum_1.ESMSBriccsError.countryUndefined]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.invalidCountry]: sms_enum_1.ESMSResponseCode.payloadError,
            [sms_briccs_enum_1.ESMSBriccsError.messageFailedDueToUndefinedPriceForGatewayUser]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_briccs_enum_1.ESMSBriccsError.messageFailedDueToLossProtection2]: sms_enum_1.ESMSResponseCode.internalError,
            [sms_briccs_enum_1.ESMSBriccsError.messageFailedDueToUndefinedRoute]: sms_enum_1.ESMSResponseCode.internalError,
        };
        setTimeout(() => {
            this.host = environment_service_1.evt.BRICCS_HOST;
            this.config = {
                [sms_enum_1.ESMSType.promotional]: {
                    apiKey: environment_service_1.evt.BRICCS_PROMOTIONAL_API_KEY,
                    clientId: environment_service_1.evt.BRICCS_PROMOTIONAL_CLIENT_ID,
                    shortCode: environment_service_1.evt.BRICCS_PROMOTIONAL_SHORT_CODE,
                },
                [sms_enum_1.ESMSType.transactional]: {
                    apiKey: environment_service_1.evt.BRICCS_TRANSACTIONAL_API_KEY,
                    clientId: environment_service_1.evt.BRICCS_TRANSACTIONAL_CLIENT_ID,
                    shortCode: environment_service_1.evt.BRICCS_TRANSACTIONAL_SHORT_CODE,
                },
            };
        }, 300);
        this.sender = async (data) => {
            if (!data.shortCode?.code) {
                await this.handleWrongShortCode(data);
                return data;
            }
            const config = this.config[data.type];
            const dateTimeSent = Date.now();
            const reqPayload = {
                SenderId: data.shortCode.code,
                Is_Unicode: false,
                Is_Flash: false,
                Message: data.message,
                MobileNumbers: this.numberJoiner(data),
                ApiKey: config.apiKey,
                ClientId: config.clientId,
            };
            const res = await this.apiS.post(this.host + '/api/v2/SendSMS', reqPayload);
            if (res?.ErrorCode) {
                await Promise.all(data.recipients.map(await this.recipientUpdaterAfterTrans(() => ({
                    dateTimeSent,
                    dateTimeFailed: Date.now(),
                    status: sms_enum_1.ESMSStatus.failed,
                    pErrorCode: res.ErrorCode + '',
                    pErrorMessage: res.ErrorDescription,
                    error: this.errorMap[res.ErrorCode],
                    resolvedFeedback: true,
                }))));
            }
            else if (Array.isArray(res?.Data))
                await Promise.all(data.recipients.map(await this.recipientUpdaterAfterTrans((r, i) => {
                    const resData = res.Data.find((x) => x.MobileNumber == r.recipient);
                    const transUpdate = resData?.MessageErrorCode
                        ? {
                            dateTimeFailed: Date.now(),
                            status: sms_enum_1.ESMSStatus.failed,
                            pErrorCode: resData.MessageErrorCode + '',
                            pErrorMessage: resData.MessageErrorDescription,
                            pMessageID: resData.MessageId,
                            error: this.errorMap[resData.MessageErrorCode],
                        }
                        : {
                            dateTimeSent: Date.now(),
                            status: sms_enum_1.ESMSStatus.sent,
                            pMessageID: resData.MessageId,
                        };
                    return {
                        dateTimeSent,
                        ...transUpdate,
                    };
                })));
            return data;
        };
        this.reconciliationHandler = (t) => {
            const config = this.config[t.recipient.sms.type];
            return this.apiS
                .get(this.host + '/api/v2/MessageStatus', {
                ApiKey: config.apiKey,
                ClientId: config.clientId,
                MessageId: t.pMessageID,
            })
                .then(async (r) => {
                const doneDate = r.Data?.DoneDate
                    ? new Date(r.Data?.DoneDate).getTime()
                    : null;
                return {
                    resolvedFeedback: true,
                    dateTimeDelivered: r.Data?.Status == 'DELIVRD' ? doneDate : null,
                    dateTimeFailed: r.Data?.Status == 'REJECTD' ? doneDate : null,
                    status: r.Data?.Status == 'DELIVRD'
                        ? sms_enum_1.ESMSStatus.delivered
                        : r.Data?.Status == 'REJECTD' || r.Data?.Status == 'BLACKLIST'
                            ? sms_enum_1.ESMSStatus.failed
                            : t.status,
                    pErrorCode: r.ErrorCode || r.Data?.ErrorCode != '000'
                        ? r.ErrorCode + '' || r.Data?.ErrorCode
                        : t.pErrorCode,
                    pErrorMessage: r.ErrorCode || r.Data?.ErrorCode != '000'
                        ? r.ErrorDescription || r.Data?.Status
                        : t.pErrorMessage,
                    error: r.ErrorCode || r.Data?.ErrorCode != '000'
                        ? this.errorMap[r.ErrorCode || r.Data.ErrorCode]
                        : null,
                };
            });
        };
    }
};
exports.BriccsProviderService = BriccsProviderService;
exports.BriccsProviderService = BriccsProviderService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [api_service_1.APIService,
        core_1.ModuleRef])
], BriccsProviderService);
let BriccsProviderServiceModule = class BriccsProviderServiceModule {
};
exports.BriccsProviderServiceModule = BriccsProviderServiceModule;
exports.BriccsProviderServiceModule = BriccsProviderServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature([])],
        providers: [BriccsProviderService],
        exports: [BriccsProviderService],
    })
], BriccsProviderServiceModule);
//# sourceMappingURL=briccs-provider.service.js.map