import { SMSProviderBaseService } from './sms-provider.base.service';
import { ESMSResponseCode, ESMSType } from '../../../enums/sms/sms.enum';
import { APIService } from '../../api.service';
import { ModuleRef } from '@nestjs/core';
import { ESMSBriccsError } from '../../../enums/sms/sms.briccs.enum';
export declare class BriccsProviderService extends SMSProviderBaseService {
    protected apiS: APIService;
    protected moduleRef: ModuleRef;
    protected config: {
        [t in ESMSType]: {
            apiKey: string;
            clientId: string;
            shortCode: string;
        };
    };
    protected errorMap: {
        [k in ESMSBriccsError]: ESMSResponseCode;
    };
    protected host: string;
    constructor(apiS: APIService, moduleRef: ModuleRef);
}
export declare class BriccsProviderServiceModule {
}
