"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var SMSAdminSearchCacheService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSAdminSearchCacheServiceModule = exports.SMSAdminSearchCacheService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const sms_view_entity_1 = require("../../entities/sms/sms.view.entity");
const sms_admin_search_cache_repository_1 = require("../../repositories/sms/sms-admin-search-cache.repository");
const sms_admin_search_cache_entity_1 = require("../../entities/sms/sms-admin-search-cache.entity");
const typeorm_3 = require("@nestjs/typeorm");
let SMSAdminSearchCacheService = SMSAdminSearchCacheService_1 = class SMSAdminSearchCacheService {
    constructor(cacheRepository, adminViewRepository) {
        this.cacheRepository = cacheRepository;
        this.adminViewRepository = adminViewRepository;
        this.logger = new common_1.Logger(SMSAdminSearchCacheService_1.name);
        this.refreshIntervalMs = 5 * 60 * 1000;
    }
    async onModuleInit() {
        try {
            await this.refreshCache();
        }
        catch (error) {
            this.logger.error('Failed to seed SMS admin search cache', error?.stack);
        }
        this.scheduleRefresh();
    }
    async onModuleDestroy() {
        if (this.refreshTimer) {
            clearInterval(this.refreshTimer);
            this.refreshTimer = undefined;
        }
    }
    async getCachedResults() {
        return this.cacheRepository.find({
            order: { cachedAt: 'DESC' },
        });
    }
    async refreshCache() {
        return;
        const snapshot = await this.fetchAdminTransactions();
        const cachedAt = Date.now();
        await this.cacheRepository.manager.transaction(async (manager) => {
            await manager.clear(sms_admin_search_cache_entity_1.SMSAdminSearchCacheEntity);
            const entities = snapshot.map((record) => this.cacheRepository.create({
                transactionId: record.id,
                status: record.status,
                type: record.type,
                providerId: record.providerId,
                providerName: record.providerName,
                clientId: record.clientId,
                clientName: record.clientName,
                shortCodeId: record.shortCodeId,
                shortCode: record.shortCode,
                recipient: record.recipient,
                message: record.message,
                amount: record.amount,
                dateTimeSent: record.dateTimeSent,
                dateTimeDelivered: record.dateTimeDelivered,
                dateTimeFailed: record.dateTimeFailed,
                cachedAt,
                payload: record,
            }));
            if (entities.length > 0) {
                await manager.save(sms_admin_search_cache_entity_1.SMSAdminSearchCacheEntity, entities);
            }
        });
        this.logger.debug(`SMS admin search cache refreshed with ${snapshot.length} records`);
    }
    async fetchAdminTransactions() {
        return this.adminViewRepository.find();
    }
    scheduleRefresh() {
        if (this.refreshTimer) {
            clearInterval(this.refreshTimer);
        }
        this.refreshTimer = setInterval(() => {
            this.refreshCache().catch((error) => {
                this.logger.error('Failed to refresh SMS admin search cache', error?.stack);
            });
        }, this.refreshIntervalMs);
    }
};
exports.SMSAdminSearchCacheService = SMSAdminSearchCacheService;
exports.SMSAdminSearchCacheService = SMSAdminSearchCacheService = SMSAdminSearchCacheService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectRepository)(sms_view_entity_1.SMSTransactionAdminView)),
    __metadata("design:paramtypes", [sms_admin_search_cache_repository_1.SMSAdminSearchCacheRepository,
        typeorm_2.Repository])
], SMSAdminSearchCacheService);
let SMSAdminSearchCacheServiceModule = class SMSAdminSearchCacheServiceModule {
};
exports.SMSAdminSearchCacheServiceModule = SMSAdminSearchCacheServiceModule;
exports.SMSAdminSearchCacheServiceModule = SMSAdminSearchCacheServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [
            typeorm_3.TypeOrmModule.forFeature([
                sms_view_entity_1.SMSTransactionAdminView,
                sms_admin_search_cache_entity_1.SMSAdminSearchCacheEntity,
            ]),
            sms_admin_search_cache_repository_1.SMSAdminSearchCacheRepositoryModule,
        ],
        providers: [SMSAdminSearchCacheService],
        exports: [SMSAdminSearchCacheService],
    })
], SMSAdminSearchCacheServiceModule);
//# sourceMappingURL=sms-admin-search-cache.service.js.map