import { Logger, OnModuleDestroy, OnModuleInit } from '@nestjs/common';
import { Repository } from 'typeorm';
import { SMSTransactionAdminView } from '../../entities/sms/sms.view.entity';
import { SMSAdminSearchCacheRepository } from '../../repositories/sms/sms-admin-search-cache.repository';
import { SMSAdminSearchCacheEntity } from '../../entities/sms/sms-admin-search-cache.entity';
export declare class SMSAdminSearchCacheService implements OnModuleInit, OnModuleDestroy {
    protected readonly cacheRepository: SMSAdminSearchCacheRepository;
    protected readonly adminViewRepository: Repository<SMSTransactionAdminView>;
    protected readonly logger: Logger;
    protected readonly refreshIntervalMs: number;
    protected refreshTimer?: NodeJS.Timeout;
    constructor(cacheRepository: SMSAdminSearchCacheRepository, adminViewRepository: Repository<SMSTransactionAdminView>);
    onModuleInit(): Promise<void>;
    onModuleDestroy(): Promise<void>;
    getCachedResults(): Promise<SMSAdminSearchCacheEntity[]>;
    refreshCache(): Promise<void>;
    protected fetchAdminTransactions(): Promise<SMSTransactionAdminView[]>;
    protected scheduleRefresh(): void;
}
export declare class SMSAdminSearchCacheServiceModule {
}
