"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShortCodeServiceModule = exports.ShortCodeService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../base.service");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const environment_service_1 = require("../environment.service");
const short_code_entity_1 = require("../../entities/short-code/short-code.entity");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const client_service_1 = require("../partner/client.service");
const short_code_enum_1 = require("../../enums/short-code.enum");
const provider_enum_1 = require("../../enums/provider.enum");
const provider_service_1 = require("../partner/provider.service");
const utility_service_1 = require("../utility.service");
const typeorm_3 = require("@nestjs/typeorm");
let ShortCodeService = class ShortCodeService extends base_service_1.BaseService {
    constructor(repo, clientService, providerService) {
        super(repo, base_enum_1.ETableName.shortCodes);
        this.repo = repo;
        this.clientService = clientService;
        this.providerService = providerService;
        this.queryStruct = [
            { field: 'code', condition: la_nest_library_1.ESearchCondition.contains },
            { field: 'orgID' },
            { field: 'id' },
            { field: 'status' },
        ];
    }
    async setupTestShortCodes(client) {
        const shortCodes = await this.repo.find({
            where: { orgID: client.id },
        });
        const codes = {
            [provider_enum_1.EProvider.briccs]: [
                environment_service_1.evt.BRICCS_TRANSACTIONAL_SHORT_CODE,
            ],
            [provider_enum_1.EProvider.hollatags]: ['MESAJ'],
            [provider_enum_1.EProvider.monty]: ['UCP'],
        };
        return Promise.all(Object.entries(codes).map(async ([providerCode, codes]) => {
            const provider = await this.providerService.getSingle({
                providerCode: providerCode,
            });
            return codes.map((code) => {
                const existing = shortCodes.find((s) => s.code == code);
                if (existing)
                    return shortCodes;
                else
                    return this.repo.save(this.repo.create({
                        code,
                        orgID: client.id,
                        status: short_code_enum_1.EShortCodeStatus.whitelisted,
                    }));
            });
        }));
    }
    getByCode(shortCode, ownerId) {
        return this.getSingle({
            code: shortCode.trim(),
            status: short_code_enum_1.EShortCodeStatus.whitelisted,
            orgID: ownerId,
        });
    }
    async setShortCodesStatus(body, auth) {
        await this.repo.manager.transaction(async (manager) => {
            await Promise.all(body.ids.map(async (id) => {
                const exists = await manager.existsBy(short_code_entity_1.ShortCodeEntity, { id });
                if (!exists)
                    utility_service_1.UtilityClass.throwError({
                        message: `Short code ${id} does not exist`,
                    });
                await manager.update(short_code_entity_1.ShortCodeEntity, { id }, this.repo.create({ status: body.status, updaterId: auth.id }));
            }));
        });
        return { message: 'Done' };
    }
    getSingle(where, auth) {
        auth;
        return this.repo.findOne({
            where: { ...where },
        });
    }
    async _createChecks(data) {
        data.code = data.code.trim();
        await this.checkIfUniqueBy({
            code: data.code,
            orgID: data.orgID,
        }, { errorMessage: `Code already exists` });
    }
    _create(data, config) {
        return super._create(data, config);
    }
    async shortCodeAnalysis(auth, query) {
        query = query || {};
        if (auth.isClient)
            query.clientID = auth.id;
        else if (auth.isPublic)
            query.clientID = (await this.clientService.authToClient(auth))?.id;
        const response = {
            whitelisted: 0,
            toBeWhitelisted: 0,
            toBeDropped: 0,
        };
        await Promise.all(Object.entries(short_code_enum_1.EShortCodeStatus).map(async ([key, value]) => (response[key] = await this.repo.count({
            where: { orgID: query.clientID, status: value },
        }))));
        return response;
    }
    requestShortcodeWhitelist(body, auth) {
        return this.requestShortcode(body, short_code_enum_1.EShortCodeStatus.toBeWhitelisted, auth);
    }
    requestShortcodeDrop(body, auth) {
        return this.requestShortcode(body, short_code_enum_1.EShortCodeStatus.toBeDropped, auth);
    }
    async requestShortcode({ orgID, ...body }, status, auth) {
        const clientID = auth.isAdmin
            ? orgID
            : await this.clientService.authIDToClientID(auth.id);
        const codesOnly = [], codesObject = [];
        body.codes.forEach((_code) => {
            const code = _code.trim();
            codesObject.push({
                code: code,
            });
            codesOnly.push(code);
        });
        const response = {
            whitelisted: 0,
            toBeWhitelisted: 0,
            toBeDropped: 0,
        };
        await this.repo.manager.transaction(async (manager) => {
            const existingMatches = await this.repo.find({
                where: { orgID: clientID, code: (0, typeorm_1.In)(codesOnly) },
                select: { id: true, status: true, code: true },
            });
            const existingMatchesMap = existingMatches.toMap('code');
            await Promise.all(codesObject.map(async (c) => {
                const existing = existingMatchesMap[c.code];
                if (status == short_code_enum_1.EShortCodeStatus.toBeWhitelisted) {
                    if (existing) {
                        if (existing.status == short_code_enum_1.EShortCodeStatus.whitelisted)
                            response.whitelisted++;
                        if (existing.status == short_code_enum_1.EShortCodeStatus.toBeWhitelisted)
                            response.toBeWhitelisted++;
                        if (existing.status == short_code_enum_1.EShortCodeStatus.toBeDropped)
                            response.toBeDropped++;
                    }
                    else {
                        await manager.save(this.repo.create({
                            code: c.code,
                            orgID: clientID,
                            status: short_code_enum_1.EShortCodeStatus.toBeWhitelisted,
                        }));
                        response.toBeWhitelisted++;
                    }
                }
                else if (existing) {
                    await manager.update(short_code_entity_1.ShortCodeEntity, { id: existing.id }, this.repo.create({
                        status,
                    }));
                }
            }));
        });
        return response;
    }
};
exports.ShortCodeService = ShortCodeService;
ShortCodeService.path = 'shortcode';
exports.ShortCodeService = ShortCodeService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(short_code_entity_1.ShortCodeEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        client_service_1.ClientService,
        provider_service_1.ProviderService])
], ShortCodeService);
let ShortCodeServiceModule = class ShortCodeServiceModule {
};
exports.ShortCodeServiceModule = ShortCodeServiceModule;
exports.ShortCodeServiceModule = ShortCodeServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([short_code_entity_1.ShortCodeEntity])],
        providers: [ShortCodeService],
        exports: [ShortCodeService],
    })
], ShortCodeServiceModule);
//# sourceMappingURL=short-code.service.js.map