import { BaseService } from '../base.service';
import { FindOptionsWhere, Repository } from 'typeorm';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { CreateShortCodeDTO, RequestShortCodesDTO, SearchShortCodeDTO, SetShortCodesStatus, ShortCodeAnalysisDto, ShortCodeAnalysisReqDto } from '../../dtos/short-code.dto';
import { ShortCodeEntity } from '../../entities/short-code/short-code.entity';
import { ICreateConfig } from '@serene-dev/la-nest-library';
import { ClientService } from '../partner/client.service';
import { EShortCodeStatus } from '../../enums/short-code.enum';
import { PartnerEntity } from '../../entities/partner.entity';
import { ProviderService } from '../partner/provider.service';
export declare class ShortCodeService extends BaseService<ShortCodeEntity, SearchShortCodeDTO> {
    repo: Repository<ShortCodeEntity>;
    protected clientService: ClientService;
    protected providerService: ProviderService;
    static path: string;
    constructor(repo: Repository<ShortCodeEntity>, clientService: ClientService, providerService: ProviderService);
    setupTestShortCodes(client: PartnerEntity): Promise<(ShortCodeEntity[] | Promise<ShortCodeEntity>)[][]>;
    getByCode(shortCode: string, ownerId?: string): Promise<ShortCodeEntity>;
    setShortCodesStatus(body: SetShortCodesStatus, auth: IAuthParam): Promise<{
        message: string;
    }>;
    getSingle(where: FindOptionsWhere<ShortCodeEntity>, auth?: IAuthParam): Promise<ShortCodeEntity>;
    _createChecks(data: CreateShortCodeDTO): Promise<void>;
    _create(data: CreateShortCodeDTO, config?: ICreateConfig): Promise<ShortCodeEntity>;
    shortCodeAnalysis(auth: IAuthParam, query?: ShortCodeAnalysisReqDto): Promise<ShortCodeAnalysisDto>;
    requestShortcodeWhitelist(body: RequestShortCodesDTO, auth: IAuthParam): Promise<ShortCodeAnalysisDto>;
    requestShortcodeDrop(body: RequestShortCodesDTO, auth: IAuthParam): Promise<ShortCodeAnalysisDto>;
    protected requestShortcode({ orgID, ...body }: RequestShortCodesDTO, status: EShortCodeStatus, auth: IAuthParam): Promise<ShortCodeAnalysisDto>;
}
export declare class ShortCodeServiceModule {
}
