"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShortCodeProviderServiceModule = exports.ShortCodeProviderService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../base.service");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const short_code_entity_1 = require("../../entities/short-code/short-code.entity");
const provider_service_1 = require("../partner/provider.service");
const typeorm_3 = require("@nestjs/typeorm");
let ShortCodeProviderService = class ShortCodeProviderService extends base_service_1.BaseService {
    constructor(repo, providerService) {
        super(repo, base_enum_1.ETableName.shortCodesByProvider);
        this.repo = repo;
        this.providerService = providerService;
    }
    async create(data, auth) {
        await this.checkIfUniqueBy({}, {
            errorMessage: `Short code has already been registered under the provider ${data.provider.providerCode}`,
        });
        return await this.repo.save(this.repo.create({ creatorId: auth.id, ...data }));
    }
};
exports.ShortCodeProviderService = ShortCodeProviderService;
ShortCodeProviderService.path = 'shortcode';
exports.ShortCodeProviderService = ShortCodeProviderService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(short_code_entity_1.ShortCodeByProviderEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        provider_service_1.ProviderService])
], ShortCodeProviderService);
let ShortCodeProviderServiceModule = class ShortCodeProviderServiceModule {
};
exports.ShortCodeProviderServiceModule = ShortCodeProviderServiceModule;
exports.ShortCodeProviderServiceModule = ShortCodeProviderServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([short_code_entity_1.ShortCodeByProviderEntity])],
        providers: [ShortCodeProviderService],
        exports: [ShortCodeProviderService],
    })
], ShortCodeProviderServiceModule);
//# sourceMappingURL=short-code-provider.service.js.map