import { BaseService } from '../base.service';
import { Repository } from 'typeorm';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { ShortCodeByProviderEntity, ShortCodeEntity } from '../../entities/short-code/short-code.entity';
import { EShortCodeStatus } from '../../enums/short-code.enum';
import { PartnerEntity } from '../../entities/partner.entity';
import { ProviderService } from '../partner/provider.service';
export declare class ShortCodeProviderService extends BaseService<ShortCodeByProviderEntity> {
    repo: Repository<ShortCodeByProviderEntity>;
    protected providerService: ProviderService;
    static path: string;
    constructor(repo: Repository<ShortCodeByProviderEntity>, providerService: ProviderService);
    create(data: {
        shortCode: ShortCodeEntity;
        provider: PartnerEntity;
        status: EShortCodeStatus;
    }, auth?: IAuthParam): Promise<ShortCodeByProviderEntity>;
}
export declare class ShortCodeProviderServiceModule {
}
