"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportServiceModule = exports.ReportService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const typeorm_3 = require("@nestjs/typeorm");
const report_entity_1 = require("../entities/report.entity");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const la_nest_library_2 = require("@serene-dev/la-nest-library");
const path = require("path");
const fs_1 = require("fs");
const util_1 = require("util");
const utility_service_1 = require("./utility.service");
const mkdirAsync = (0, util_1.promisify)(fs_1.mkdir);
let ReportService = class ReportService {
    constructor(reportRepository) {
        this.reportRepository = reportRepository;
        this.CHUNK_SIZE = 20;
        this.REPORTS_DIR = 'reports';
    }
    async createAndGenerateReport(reportType, getterFunction, searchQuery, auth) {
        const reportNumber = await this.generateReportNumber(reportType);
        const cleanedQuery = this.cleanQueryForStorage(searchQuery);
        const report = this.reportRepository.create({
            reportType,
            reportNumber,
            status: report_entity_1.EReportStatus.pending,
            requestedBy: auth?.id,
            processedRecords: 0,
            processedChunks: 0,
            query: JSON.stringify(cleanedQuery),
        });
        const savedReport = await this.reportRepository.save(report);
        const reportId = savedReport.id;
        try {
            await this.reportRepository.update(reportId, {
                status: report_entity_1.EReportStatus.processing,
                processedRecords: 0,
                processedChunks: 0,
            });
            const reportsDir = path.join(utility_service_1.UtilityClass.absoluteUploadPath, this.REPORTS_DIR);
            if (!(0, fs_1.existsSync)(reportsDir)) {
                await mkdirAsync(reportsDir, { recursive: true });
            }
            const fileName = `report_${savedReport.reportType}.csv`;
            const filePath = path.join(reportsDir, fileName);
            const writeStream = (0, fs_1.createWriteStream)(filePath, { flags: 'w' });
            let totalRecords = 0;
            let processedRecords = 0;
            let processedChunks = 0;
            let headers = [];
            let isFirstChunk = true;
            let currentPage = searchQuery.pageNumber || 1;
            const pageSize = this.CHUNK_SIZE;
            while (true) {
                const query = {
                    ...searchQuery,
                    pageNumber: currentPage,
                    pageSize,
                    sortDirection: la_nest_library_1.ESortOrder.asc,
                    sortField: 'createdAt',
                };
                la_nest_library_2.logger.info({
                    reportId,
                    chunk: processedChunks + 1,
                    page: currentPage,
                }, `Processing chunk ${processedChunks + 1} for report ${reportId}`);
                const response = await getterFunction(query, auth);
                if (!response || !response.data || response.data.length === 0) {
                    break;
                }
                if (isFirstChunk) {
                    totalRecords = response.total || 0;
                    await this.reportRepository.update(reportId, {
                        totalRecords,
                    });
                }
                const flattenedData = response.data.map((item) => this.flattenObject(item));
                if (isFirstChunk && flattenedData.length > 0) {
                    headers = Object.keys(flattenedData[0]);
                    const escapedHeaders = headers.map((header) => this.escapeCSV(header));
                    writeStream.write(escapedHeaders.join(',') + '\n');
                    isFirstChunk = false;
                }
                for (const row of flattenedData) {
                    const values = headers.map((header) => {
                        const value = row[header] ?? '';
                        return this.escapeCSV(String(value));
                    });
                    writeStream.write(values.join(',') + '\n');
                    processedRecords++;
                }
                processedChunks++;
                await this.reportRepository.update(reportId, {
                    processedRecords,
                    processedChunks,
                });
                la_nest_library_2.logger.info({
                    reportId,
                    processedRecords,
                    totalRecords,
                    processedChunks,
                    progress: totalRecords > 0 ? (processedRecords / totalRecords) * 100 : 0,
                }, `Chunk ${processedChunks} processed for report ${reportId}. Progress: ${processedRecords}/${totalRecords}`);
                if (response.data.length < pageSize ||
                    processedRecords >= totalRecords ||
                    (response.total && processedRecords >= response.total)) {
                    break;
                }
                currentPage++;
            }
            writeStream.end();
            await new Promise((resolve, reject) => {
                writeStream.on('finish', resolve);
                writeStream.on('error', reject);
            });
            await this.reportRepository.update(reportId, {
                status: report_entity_1.EReportStatus.completed,
                filePath: path.join(this.REPORTS_DIR, fileName),
                processedRecords,
                processedChunks,
            });
            la_nest_library_2.logger.info({
                reportId,
                totalRecords,
                processedRecords,
                filePath,
            }, `Report ${reportId} generated successfully`);
            return await this.reportRepository.findOne({
                where: { id: reportId },
            });
        }
        catch (error) {
            la_nest_library_2.logger.error({
                reportId,
                error: error.message,
                stack: error.stack,
            }, `Error generating report ${reportId}`);
            await this.reportRepository.update(reportId, {
                status: report_entity_1.EReportStatus.failed,
                errorMessage: error.message || 'Unknown error occurred',
            });
            throw error;
        }
    }
    flattenObject(obj, prefix = '') {
        const flattened = {};
        for (const key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
                const value = obj[key];
                const newKey = prefix ? `${prefix}${this.capitalizeFirst(key)}` : key;
                if (value === null || value === undefined) {
                    flattened[newKey] = '';
                }
                else if (Array.isArray(value)) {
                    flattened[newKey] = JSON.stringify(value);
                }
                else if (typeof value === 'object' && !(value instanceof Date)) {
                    const nested = this.flattenObject(value, newKey);
                    Object.assign(flattened, nested);
                }
                else if (value instanceof Date) {
                    flattened[newKey] = value.toISOString();
                }
                else {
                    flattened[newKey] = value;
                }
            }
        }
        return flattened;
    }
    capitalizeFirst(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    }
    escapeCSV(value) {
        if (value === null || value === undefined) {
            return '';
        }
        if (value.includes(',') || value.includes('\n') || value.includes('"')) {
            return `"${value.replace(/"/g, '""')}"`;
        }
        return value;
    }
    cleanQueryForStorage(query) {
        const cleanedQuery = { ...query };
        delete cleanedQuery.pageNumber;
        delete cleanedQuery.pageSize;
        delete cleanedQuery.sortField;
        delete cleanedQuery.sortDirection;
        return cleanedQuery;
    }
    async generateReportNumber(reportType) {
        const count = await this.reportRepository.count({
            where: { reportType },
        });
        const reportNumber = `RPT-${count + 1}`;
        return reportNumber;
    }
    async createReport(reportType, auth) {
        const reportNumber = await this.generateReportNumber(reportType);
        const report = this.reportRepository.create({
            reportType,
            reportNumber,
            status: report_entity_1.EReportStatus.pending,
            requestedBy: auth?.id,
            processedRecords: 0,
            processedChunks: 0,
        });
        return await this.reportRepository.save(report);
    }
    async getReport(reportId) {
        const report = await this.reportRepository.findOne({
            where: { id: reportId },
        });
        if (!report) {
            throw new Error('Report not found');
        }
        return report;
    }
    async search(query, auth) {
        const baseWhere = {};
        if (auth && !auth.isAdmin) {
            baseWhere.requestedBy = auth.id;
        }
        return utility_service_1.UtilityClass.search(this.reportRepository, query, {
            baseWhere,
        });
    }
    getReportFilePath(report) {
        if (!report.filePath) {
            return null;
        }
        return path.join(utility_service_1.UtilityClass.absoluteUploadPath, report.filePath);
    }
    async handleSearchWithExport(query, searchFunction, reportType, auth) {
        const { isExport, ...searchQuery } = query;
        if (isExport) {
            const report = await this.createAndGenerateReport(reportType, searchFunction, searchQuery, auth);
            return { data: [], total: 0, report };
        }
        if (!auth) {
            throw new Error('Authentication is required for search');
        }
        return await searchFunction(searchQuery, auth);
    }
};
exports.ReportService = ReportService;
exports.ReportService = ReportService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(report_entity_1.ReportEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ReportService);
let ReportServiceModule = class ReportServiceModule {
};
exports.ReportServiceModule = ReportServiceModule;
exports.ReportServiceModule = ReportServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([report_entity_1.ReportEntity])],
        providers: [ReportService],
        exports: [ReportService],
    })
], ReportServiceModule);
//# sourceMappingURL=report.service.js.map