import { Repository } from 'typeorm';
import { ReportEntity, EReportType } from '../entities/report.entity';
import { SearchQueryDto } from '../entities/base.entity';
import { ISearchResponse } from '@serene-dev/la-nest-library';
import { IAuthParam } from '../modules/authentication/interfaces/authentication.interface';
export type ReportDataGetter<T = any> = (query: SearchQueryDto, auth?: IAuthParam) => Promise<ISearchResponse<T>>;
export declare class ReportService {
    private readonly reportRepository;
    private readonly CHUNK_SIZE;
    private readonly REPORTS_DIR;
    constructor(reportRepository: Repository<ReportEntity>);
    createAndGenerateReport<T = any>(reportType: EReportType, getterFunction: ReportDataGetter<T>, searchQuery: SearchQueryDto, auth?: IAuthParam): Promise<ReportEntity>;
    private flattenObject;
    private capitalizeFirst;
    private escapeCSV;
    private cleanQueryForStorage;
    private generateReportNumber;
    createReport(reportType: EReportType, auth?: IAuthParam): Promise<ReportEntity>;
    getReport(reportId: string): Promise<ReportEntity>;
    search(query: SearchQueryDto, auth?: IAuthParam): Promise<ISearchResponse<ReportEntity>>;
    getReportFilePath(report: ReportEntity): string | null;
    handleSearchWithExport<T = any>(query: SearchQueryDto & {
        isExport?: boolean;
    }, searchFunction: (query: SearchQueryDto, auth: IAuthParam) => Promise<ISearchResponse<T>>, reportType: EReportType, auth?: IAuthParam): Promise<ISearchResponse<T> | {
        data: any[];
        total: number;
        report: ReportEntity;
    }>;
}
export declare class ReportServiceModule {
}
