"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductServiceModule = exports.ProductService = void 0;
const common_1 = require("@nestjs/common");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const products_config_1 = require("../configs/products.config");
const typeorm_1 = require("typeorm");
const product_entity_1 = require("../entities/product/product.entity");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../enums/base.enum");
const analytics_enum_1 = require("../enums/analytics.enum");
const partner_repository_1 = require("../repositories/partner.repository");
const partner_enum_1 = require("../enums/partner.enum");
const product_group_entity_1 = require("../entities/product/product-group.entity");
const lodash_1 = require("lodash");
const typeorm_3 = require("@nestjs/typeorm");
let ProductService = class ProductService {
    constructor(repo, repoGroup, pricingService, loggerService, partnerRepository) {
        this.repo = repo;
        this.repoGroup = repoGroup;
        this.pricingService = pricingService;
        this.loggerService = loggerService;
        this.partnerRepository = partnerRepository;
        this.pricingRefCat = `CLIENT_SMS`;
    }
    async getAnalytics() {
        await this.pricingList();
        const pricingList = this._pricingListGrouped;
        return Promise.all(pricingList.map(async (g) => ({
            header: `Client Share - ${g.title}`,
            type: analytics_enum_1.EChartType.bar,
            data: await Promise.all(g.products.map(async (p) => ({
                label: p.minVolume + ' - ' + p.maxVolume,
                value: await this.partnerRepository.countBy([
                    {
                        currentPromotionalProductId: p.id,
                        type: partner_enum_1.EPartnerType.client,
                    },
                    {
                        currentTransactionalProductId: p.id,
                        type: partner_enum_1.EPartnerType.client,
                    },
                ]),
            }))),
        })));
    }
    async pricingList() {
        return this._pricingList || (await this.loadFromDB());
    }
    async getPricingById(productID) {
        return this._pricingListMap[productID];
    }
    async loadPricingToDBFromConfig() {
        try {
            const existingDBGroups = await this.repoGroup.find();
            const existingDBPricings = await this.repo.find();
            await this.repo.manager.transaction(async (manager) => {
                try {
                    const groups = Object.entries(products_config_1.ProductsConfig);
                    await Promise.all(groups.map(async ([group, { title, products: productsConfig }]) => {
                        const groupCode = group;
                        const _existingGroup = existingDBGroups.find((x) => x.providerCode == groupCode);
                        const existingGroup = await manager.save(product_group_entity_1.ProductGroupEntity, this.repoGroup.create({
                            providerCode: groupCode,
                            title,
                            id: _existingGroup?.id,
                        }));
                        const configList = Object.entries(productsConfig);
                        await Promise.all(configList.map(async ([_maxVolume, smsTypeObj], index) => {
                            const minVolume = +configList[index - 1]?.[0] + 1 || 0;
                            const maxVolume = +_maxVolume;
                            const existing = existingDBPricings.find((x) => x.minVolume == minVolume &&
                                x.maxVolume == maxVolume &&
                                x.groupId == existingGroup.id);
                            const promotional = manager.create(la_nest_library_1.PricingEntity, {
                                amount: smsTypeObj.PROMOTIONAL.fee,
                                active: !smsTypeObj.PROMOTIONAL.inactive,
                                refCat: this.pricingRefCat,
                                id: existing?.promotionalId,
                            });
                            const transactional = manager.create(la_nest_library_1.PricingEntity, {
                                amount: smsTypeObj.TRANSACTIONAL.fee,
                                active: !smsTypeObj.TRANSACTIONAL.inactive,
                                refCat: this.pricingRefCat,
                                id: existing?.transactionalId,
                            });
                            await manager.save(product_entity_1.ProductEntity, this.repo.create({
                                id: existing?.id,
                                minVolume,
                                maxVolume,
                                promotional,
                                transactional,
                                groupId: existingGroup.id,
                            }));
                        }));
                    }));
                }
                catch (error) {
                    throw error;
                }
            });
            await this.pricingList();
        }
        catch (error) {
            this.loggerService._create({
                isError: true,
                message: error,
                refCat: base_enum_1.ELoggerRefCat.system,
            });
        }
    }
    async loadFromDB() {
        const groups = await this.repoGroup.find();
        const groupsMap = groups.toMap('id');
        this._pricingList = (await this.repo.find({
            where: { active: true },
            relations: { promotional: true, transactional: true },
        }))
            .map((x) => ({
            ...x,
            groupName: groupsMap[x.groupId]?.title,
            minAmountToPayPromotional: +(x.minVolume * x.promotional.amount).toFixed(2),
            minAmountToPayTransactional: +(x.minVolume * x.transactional.amount).toFixed(2),
        }))
            .sort2('minVolume');
        this._pricingListMap = this._pricingList.toMap('id');
        const productsMap = (0, lodash_1.groupBy)(this._pricingList, (i) => i.groupId);
        this._pricingListGrouped = groups.map((x) => ({
            title: x.title,
            id: x.id,
            products: productsMap[x.id],
        }));
        return this._pricingList;
    }
};
exports.ProductService = ProductService;
ProductService.path = new la_nest_library_1.RoutePath('product');
exports.ProductService = ProductService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(product_entity_1.ProductEntity)),
    __param(1, (0, typeorm_2.InjectRepository)(product_group_entity_1.ProductGroupEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        la_nest_library_1.PricingService,
        la_nest_library_1.LoggerDBService,
        partner_repository_1.PartnerRepository])
], ProductService);
let ProductServiceModule = class ProductServiceModule {
};
exports.ProductServiceModule = ProductServiceModule;
exports.ProductServiceModule = ProductServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([product_entity_1.ProductEntity, product_group_entity_1.ProductGroupEntity])],
        providers: [ProductService],
        exports: [ProductService],
    })
], ProductServiceModule);
//# sourceMappingURL=product.service.js.map