import { LoggerDBService, PricingService, RoutePath } from '@serene-dev/la-nest-library';
import { ProductGroupDto, ProductItemDto } from '../dtos/product.dto';
import { Repository } from 'typeorm';
import { ProductEntity } from '../entities/product/product.entity';
import { Chart } from '../dtos/analytics.dto';
import { PartnerRepository } from '../repositories/partner.repository';
import { ProductGroupEntity } from '../entities/product/product-group.entity';
export declare class ProductService {
    repo: Repository<ProductEntity>;
    repoGroup: Repository<ProductGroupEntity>;
    pricingService: PricingService;
    loggerService: LoggerDBService;
    partnerRepository: PartnerRepository;
    static path: RoutePath;
    protected _pricingList: ProductItemDto[];
    protected _pricingListGrouped: ProductGroupDto[];
    readonly pricingRefCat = "CLIENT_SMS";
    private _pricingListMap;
    constructor(repo: Repository<ProductEntity>, repoGroup: Repository<ProductGroupEntity>, pricingService: PricingService, loggerService: LoggerDBService, partnerRepository: PartnerRepository);
    getAnalytics(): Promise<Chart[]>;
    pricingList(): Promise<ProductItemDto[]>;
    getPricingById(productID: string): Promise<ProductItemDto>;
    loadPricingToDBFromConfig(): Promise<void>;
    protected loadFromDB(): Promise<ProductItemDto[]>;
}
export declare class ProductServiceModule {
}
