"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderServiceModule = exports.ProviderService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const rxjs_1 = require("rxjs");
const typeorm_2 = require("typeorm");
const partner_entity_1 = require("../../entities/partner.entity");
const partner_enum_1 = require("../../enums/partner.enum");
const provider_enum_1 = require("../../enums/provider.enum");
const partner_service_1 = require("./partner.service");
const typeorm_3 = require("@nestjs/typeorm");
let ProviderService = class ProviderService extends partner_service_1.PartnerService {
    constructor(repo) {
        super(repo, partner_enum_1.EPartnerType.provider);
        this.repo = repo;
        this.recalculateProviders = new rxjs_1.BehaviorSubject(true);
        this.queryStruct = this.baseQueryStruct.concat([{ field: 'providerCode' }]);
    }
    async setupPartners() {
        await this.repo.manager.transaction(async (manager) => {
            const providers = await this.getWhere({});
            const providersMap = providers.toMap('providerCode');
            await Promise.all(Object.values(provider_enum_1.EProvider)
                .filter((x) => !providersMap[x])
                .map((provider, i) => this._create({ name: provider, providerCode: provider, priority: i + 1 }, { auth: { id: null, token: null }, entityManager: manager })));
            this.recalculateProviders.next(true);
        });
    }
    toggleActive(id, body) {
        return super.toggleActive(id, body).then((r) => {
            this.recalculateProviders.next(true);
            return r;
        });
    }
    _create(data, config) {
        return super._create(data, config).then((r) => {
            this.recalculateProviders.next(true);
            return r;
        });
    }
    _updateByID(id, data, config) {
        return super._updateByID(id, data, config).then((r) => {
            this.recalculateProviders.next(true);
            return r;
        });
    }
};
exports.ProviderService = ProviderService;
ProviderService.path = 'providers';
exports.ProviderService = ProviderService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(partner_entity_1.PartnerEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ProviderService);
let ProviderServiceModule = class ProviderServiceModule {
};
exports.ProviderServiceModule = ProviderServiceModule;
exports.ProviderServiceModule = ProviderServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([partner_entity_1.PartnerEntity])],
        providers: [ProviderService],
        exports: [ProviderService],
    })
], ProviderServiceModule);
//# sourceMappingURL=provider.service.js.map