import { ICreateConfig, ToggleActiveDTO } from '@serene-dev/la-nest-library';
import { BehaviorSubject } from 'rxjs';
import { Repository } from 'typeorm';
import { CreatePartnerDTO, SearchProviderDTO, UpdatePartnerDTO } from '../../dtos/partner.dto';
import { PartnerEntity } from '../../entities/partner.entity';
import { PartnerService } from './partner.service';
export declare class ProviderService extends PartnerService<SearchProviderDTO> {
    repo: Repository<PartnerEntity>;
    static path: string;
    readonly recalculateProviders: BehaviorSubject<boolean>;
    constructor(repo: Repository<PartnerEntity>);
    setupPartners(): Promise<void>;
    toggleActive(id: string, body: ToggleActiveDTO): Promise<ToggleActiveDTO>;
    _create(data: CreatePartnerDTO, config?: ICreateConfig): Promise<PartnerEntity>;
    _updateByID(id: string, data: UpdatePartnerDTO, config?: ICreateConfig): Promise<PartnerEntity>;
}
export declare class ProviderServiceModule {
}
