import { BaseService } from '../base.service';
import { FindOptionsWhere, Repository } from 'typeorm';
import { PartnerEntity } from '../../entities/partner.entity';
import { EPartnerType } from '../../enums/partner.enum';
import { CreatePartnerDTO, SearchPartnerDTO } from '../../dtos/partner.dto';
import { ICreateConfig, ISearchQueryItem } from '@serene-dev/la-nest-library';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
export declare abstract class PartnerService<TSearchDto extends SearchPartnerDTO = SearchPartnerDTO> extends BaseService<PartnerEntity, TSearchDto> {
    repo: Repository<PartnerEntity>;
    readonly type: EPartnerType;
    protected baseQueryStruct: ISearchQueryItem<SearchPartnerDTO>[];
    constructor(repo: Repository<PartnerEntity>, type: EPartnerType);
    getWhere(where: FindOptionsWhere<PartnerEntity> | FindOptionsWhere<PartnerEntity>[]): Promise<PartnerEntity[]>;
    getSingle(where: FindOptionsWhere<PartnerEntity>, auth?: IAuthParam): Promise<PartnerEntity>;
    protected _createFunction(requestData: CreatePartnerDTO, config?: ICreateConfig): Promise<PartnerEntity>;
    _create(data: CreatePartnerDTO, config?: ICreateConfig): Promise<PartnerEntity>;
}
