"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientServiceModule = exports.ClientService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const typeorm_2 = require("typeorm");
const partner_entity_1 = require("../../entities/partner.entity");
const partner_enum_1 = require("../../enums/partner.enum");
const token_service_1 = require("../token.service");
const utility_service_1 = require("../utility.service");
const partner_service_1 = require("./partner.service");
const sms_enum_1 = require("../../enums/sms/sms.enum");
const product_service_1 = require("../product.service");
const wallet_enum_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.enum");
const base_enum_1 = require("../../enums/base.enum");
const public_users_service_1 = require("../../modules/authentication/services/public-users.service");
const typeorm_3 = require("@nestjs/typeorm");
let ClientService = class ClientService extends partner_service_1.PartnerService {
    constructor(repo, tokenService, tokenSessionService, productService, walletService, publicUsersService, walletTransactionService) {
        super(repo, partner_enum_1.EPartnerType.client);
        this.repo = repo;
        this.tokenService = tokenService;
        this.tokenSessionService = tokenSessionService;
        this.productService = productService;
        this.walletService = walletService;
        this.publicUsersService = publicUsersService;
        this.walletTransactionService = walletTransactionService;
        this.smsTypeWalletFieldMap = [
            { smsType: sms_enum_1.ESMSType.promotional, field: 'promotionalWalletId' },
            { smsType: sms_enum_1.ESMSType.transactional, field: 'transactionalWalletId' },
        ];
    }
    async getOrCreateWallet(clientID, config) {
        if (!clientID)
            utility_service_1.UtilityClass.throwError({ message: 'Client id is missing' });
        const client = await this.repo.findOne({
            where: { id: clientID },
            relations: { promotionalWallet: true, transactionalWallet: true },
            select: {
                id: true,
                promotionalWalletId: true,
                transactionalWalletId: true,
                name: true,
            },
        });
        if (!client)
            utility_service_1.UtilityClass.throwError({ message: 'Client could not be found' });
        else {
            await Promise.all(this.smsTypeWalletFieldMap.map(async ({ field, smsType }) => {
                if (!client[field]) {
                    const wallet = await this.walletService._create({
                        name: client.name + ' ' + smsType,
                        active: true,
                        allowOverdraft: false,
                        type: smsType,
                        orgID: clientID,
                    }, { ...config, entityManager: config?.entityManager });
                    client[field] = wallet.id;
                    await this._updateByID(clientID, { [field]: wallet.id });
                }
            }));
        }
        return await Promise.all(this.smsTypeWalletFieldMap.map(({ field, smsType }) => this.walletService
            .getComputed({ id: client[field] })
            .then((r) => ({ wallet: r, type: smsType }))));
    }
    async getWalletByID(walletID, auth) {
        return auth?.isAdmin
            ? this.walletService.getComputed({ id: walletID })
            : this.getOrCreateWalletByAuth(auth);
    }
    async getWalletByClientIDLite(clientID, smsType) {
        return this.walletService.getComputed({ orgID: clientID, type: smsType });
    }
    async createPublic(body) {
        const client = await this._create(body.client);
        try {
            delete body.user.login;
            body.user.orgID = client.id;
            await this.publicUsersService.createUser(body.user);
            return await this.publicUsersService.login({
                email: body.user.email,
                orgID: body.user.orgID,
                password: body.user.password,
            });
        }
        catch (error) {
            this.repo.delete({ id: client.id });
            utility_service_1.UtilityClass.throwError({ error: error });
        }
    }
    async searchWalletTransactions(query, auth) {
        if (auth.isPublic)
            query.walletIds = (await this.getOrCreateWalletByAuth(auth)).map((x) => x.wallet.id);
        else if (auth.isClient)
            query.walletIds = (await this.getOrCreateWallet(auth.id)).map((x) => x.wallet.id);
        else if (!auth.isAdmin)
            utility_service_1.UtilityClass.throwError({
                statusCode: 401,
                message: `Unauthorized to search transactions`,
            });
        return this.walletTransactionService.search(query);
    }
    async getOrCreateWalletByAuth(auth) {
        return this.getOrCreateWallet(await this.getClientIDByAuthID(auth.id));
    }
    async topupWallet(walletID, body, auth) {
        if (!auth?.isAdmin) {
            const clientID = await this.getClientIDByAuthID(auth.id);
            await this.walletService.checkIfExistsBy({ orgID: clientID }, { errorMessage: `Wallet could not be found` });
        }
        return this.walletTransactionService.create(walletID, body);
    }
    async setupTestClient() {
        const testEmail = 'ahmeddapo0110@outlook.com';
        const client = await this.getSingle({
            email: testEmail,
        });
        return !client
            ? await this._create({
                name: 'Test',
                email: testEmail,
                webhookUrl: 'http://localhost:7100/webhook/test',
            })
            : client;
    }
    async generateKeyExt(auth, clientID) {
        const partner = await this.getSingle(clientID && auth.isAdmin
            ? { id: clientID }
            : { manager: { auth: { id: auth.id } } });
        if (!partner)
            utility_service_1.UtilityClass.throwError({ message: `Client was not found` });
        return await this.generateKey(partner, auth);
    }
    async generateKey(client, auth) {
        const token = await this.tokenService.generateToken({ id: client.id, isClient: true }, { expiresIn: '1y' });
        await this.tokenSessionService._create({
            ownerID: client.id,
            token: token.token,
            creator: { id: auth?.id || client?.creatorId },
        });
        await this._updateByID(client.id, { apiKey: token.token });
        if (client.email)
            la_nest_library_1.MailService.sendMail({
                to: client.email,
                html: await utility_service_1.UtilityClass.emailTemplater(`New API Key`, `A new API key has been generated for your account ${client.name}. <br> API key: <strong>${token.token}</strong>`),
                subject: `New API Key`,
                _senderName: 'Account Manager',
            });
    }
    async _preCreateFunction(data) {
        data.active = false;
    }
    async _postCreateFunction(requestData, savedData) {
        await this.generateKey(savedData);
        await this.getOrCreateWallet(savedData.id);
        return super._postCreateFunction(requestData, savedData);
    }
    async authToClient(auth) {
        if (auth.isAdmin)
            return null;
        let client;
        if (auth.isClient)
            client = await this.getSingle({ id: auth.id });
        else if (auth.isPublic)
            client = await this.getSingle({ users: { auth: { id: auth.id } } });
        if (!client)
            utility_service_1.UtilityClass.throwError({ message: `Client doesn't exist` });
        return client;
    }
    async authIDToClient(authID) {
        const client = await this.getSingle({
            users: { auth: { id: authID } },
        });
        if (!client)
            utility_service_1.UtilityClass.throwError({ message: `Client doesn't exist` });
        return client;
    }
    async authIDToClientID(authID) {
        const client = await this.repo.findOne({
            where: {
                users: { auth: { id: authID } },
            },
            select: { id: true },
        });
        if (!client)
            utility_service_1.UtilityClass.throwError({ message: `Client doesn't exist` });
        return client.id;
    }
    async getCurrentPlan(clientID) {
        return this.repo
            .findOne({
            where: { id: clientID },
            relations: {
                currentPromotionalProduct: { promotional: true, transactional: true },
                currentTransactionalProduct: {
                    promotional: true,
                    transactional: true,
                },
            },
            select: {
                id: true,
                active: true,
                currentPromotionalProduct: {
                    id: true,
                    active: true,
                    promotional: { id: true, amount: true },
                    transactional: { id: true, amount: true },
                },
                currentTransactionalProduct: {
                    id: true,
                    active: true,
                    promotional: { id: true, amount: true },
                    transactional: { id: true, amount: true },
                },
            },
        })
            .then((r) => ({
            ...r,
            currentPromotionalProduct: r?.currentPromotionalProduct,
            currentTransactionalProduct: r?.currentTransactionalProduct,
        }));
    }
    async assignClientToProduct(data, auth) {
        await this.productService.pricingList();
        const selectedProduct = await this.productService.getPricingById(data.productID);
        if (!selectedProduct)
            utility_service_1.UtilityClass.throwError({
                message: `Package could not be found`,
                statusCode: 404,
            });
        if (data.smsType == sms_enum_1.ESMSType.promotional &&
            selectedProduct.minAmountToPayPromotional > data.amount)
            utility_service_1.UtilityClass.throwError({
                message: `Package amount is below minimum expected`,
                statusCode: 403,
            });
        if (data.smsType == sms_enum_1.ESMSType.transactional &&
            selectedProduct.minAmountToPayTransactional > data.amount)
            utility_service_1.UtilityClass.throwError({
                message: `Package amount is below minimum expected`,
                statusCode: 403,
            });
        if (!auth.isAdmin &&
            data.clientID != (await this.getClientIDByAuthID(auth.id)))
            utility_service_1.UtilityClass.throwError({
                message: `Package cannot be bought for this client`,
                statusCode: 403,
            });
        await this.repo.manager.transaction(async (manager) => {
            const wallets = await this.getOrCreateWallet(data.clientID, {
                auth,
                entityManager: manager,
            });
            await Promise.all(wallets.map(async ({ wallet }) => {
                if (wallet.type == data.smsType) {
                    await this.walletTransactionService.create(wallet.id, {
                        ...data,
                        currency: wallet_enum_1.ECurrency.naira,
                        isFailed: false,
                        isVerified: true,
                        refCat: base_enum_1.ETransRefCat.productAssign,
                        reason: base_enum_1.ETransRefCat.productAssign,
                        surcharge: 0,
                        type: wallet_enum_1.ETransactionType.credit,
                    }, { entityManager: manager });
                    await manager
                        .update(partner_entity_1.PartnerEntity, { id: data.clientID }, data.smsType == sms_enum_1.ESMSType.promotional
                        ? { currentPromotionalProductId: selectedProduct.id }
                        : data.smsType == sms_enum_1.ESMSType.transactional
                            ? { currentTransactionalProductId: selectedProduct.id }
                            : {})
                        .then(() => ({ message: `Assigned to Product` }));
                }
            }));
        });
        return {
            message: `Assigned ${data.smsType} ${selectedProduct.minVolume} - ${selectedProduct.maxVolume}`,
        };
    }
    async getClientIDByAuthID(authID) {
        return await this.repo
            .findOne({
            where: { users: { auth: { id: authID } } },
            select: { id: true },
        })
            .then((r) => r?.id);
    }
    async updateWebhookUrl(auth, webhookUrl) {
        const client = await this.authToClient(auth);
        await this.repo.update(client.id, { webhookUrl });
        return {
            message: 'Webhook URL updated successfully',
        };
    }
    async getWebhookUrl(auth) {
        const client = await this.authToClient(auth);
        return {
            webhookUrl: client.webhookUrl,
        };
    }
};
exports.ClientService = ClientService;
ClientService.path = 'clients';
exports.ClientService = ClientService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(partner_entity_1.PartnerEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        token_service_1.TokenService,
        token_service_1.TokenSessionService,
        product_service_1.ProductService,
        la_nest_library_1.SDKWalletService,
        public_users_service_1.PublicUsersService,
        la_nest_library_1.SDKWalletTransactionService])
], ClientService);
let ClientServiceModule = class ClientServiceModule {
};
exports.ClientServiceModule = ClientServiceModule;
exports.ClientServiceModule = ClientServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([partner_entity_1.PartnerEntity])],
        providers: [ClientService],
        exports: [ClientService],
    })
], ClientServiceModule);
//# sourceMappingURL=client.service.js.map