import { SDKWalletEntity, SDKWalletService, SDKWalletTransactionService } from '@serene-dev/la-nest-library';
import { Repository } from 'typeorm';
import { AssignProductDto, CreateClientDTO, CreatePartnerDTO } from '../../dtos/partner.dto';
import { PartnerEntity } from '../../entities/partner.entity';
import { EPartnerType } from '../../enums/partner.enum';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { TokenService, TokenSessionService } from '../token.service';
import { PartnerService } from './partner.service';
import { GenericResponseDto } from '../../dtos/base.dto';
import { CreateWalletTransactionDTO, WalletTransactionSearchDTO } from '@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.dto';
import { ESMSType } from '../../enums/sms/sms.enum';
import { ProductService } from '../product.service';
import { ICreateConfig } from '@serene-dev/la-nest-library/dist/libs/la-library/src/interfaces/index.interface';
import { PublicUsersService } from '../../modules/authentication/services/public-users.service';
export declare class ClientService extends PartnerService {
    repo: Repository<PartnerEntity>;
    tokenService: TokenService;
    tokenSessionService: TokenSessionService;
    productService: ProductService;
    walletService: SDKWalletService;
    publicUsersService: PublicUsersService;
    walletTransactionService: SDKWalletTransactionService;
    static path: string;
    constructor(repo: Repository<PartnerEntity>, tokenService: TokenService, tokenSessionService: TokenSessionService, productService: ProductService, walletService: SDKWalletService, publicUsersService: PublicUsersService, walletTransactionService: SDKWalletTransactionService);
    protected readonly smsTypeWalletFieldMap: {
        smsType: ESMSType;
        field: 'promotionalWalletId' | 'transactionalWalletId';
    }[];
    getOrCreateWallet(clientID: string, config?: ICreateConfig): Promise<{
        wallet: import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView;
        type: ESMSType;
    }[]>;
    getWalletByID(walletID: string, auth: IAuthParam): Promise<import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView | {
        wallet: import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView;
        type: ESMSType;
    }[]>;
    getWalletByClientIDLite(clientID: string, smsType: ESMSType): Promise<import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView>;
    createPublic(body: CreateClientDTO): Promise<any>;
    searchWalletTransactions(query: WalletTransactionSearchDTO, auth: IAuthParam): Promise<import("@serene-dev/la-nest-library").ISearchResponse<import("@serene-dev/la-nest-library").SDKWalletTransaction>>;
    getOrCreateWalletByAuth(auth: IAuthParam): Promise<{
        wallet: import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView;
        type: ESMSType;
    }[]>;
    topupWallet(walletID: string, body: CreateWalletTransactionDTO, auth: IAuthParam): Promise<import("@serene-dev/la-nest-library").SDKWalletTransaction>;
    setupTestClient(): Promise<PartnerEntity>;
    generateKeyExt(auth: IAuthParam, clientID: string): Promise<void>;
    protected generateKey(client: PartnerEntity, auth?: IAuthParam): Promise<void>;
    protected _preCreateFunction(data: Partial<PartnerEntity>): Promise<void>;
    protected _postCreateFunction(requestData: CreatePartnerDTO, savedData: PartnerEntity): Promise<void>;
    authToClient(auth: IAuthParam): Promise<PartnerEntity>;
    authIDToClient(authID: string): Promise<PartnerEntity>;
    authIDToClientID(authID: string): Promise<string>;
    getCurrentPlan(clientID: string): Promise<{
        currentPromotionalProduct: import("../../entities/product/product.entity").ProductEntity;
        currentTransactionalProduct: import("../../entities/product/product.entity").ProductEntity;
        phoneNumber?: string;
        email?: string;
        priority?: number;
        apiKey?: string;
        name: string;
        type: EPartnerType;
        providerCode?: import("../../enums/provider.enum").EProvider;
        webhookUrl?: string;
        promotionalWallet?: import("typeorm").Relation<SDKWalletEntity>;
        promotionalWalletId?: string;
        transactionalWallet?: import("typeorm").Relation<SDKWalletEntity>;
        transactionalWalletId?: string;
        manager: import("typeorm").Relation<import("../../modules/authentication/entities/user-detail.entity").UserDetailEntity>;
        managerId?: string;
        currentPromotionalProductId?: string;
        currentTransactionalProductId?: string;
        users: import("typeorm").Relation<import("../../modules/authentication/entities/user-detail.entity").UserDetailEntity[]>;
        messages?: import("typeorm").Relation<import("../../entities/sms/sms.entity").SMSEntity[]>;
        messageTransactions?: import("typeorm").Relation<import("../../entities/sms/sms-transaction.entity").SMSTransactionEntity[]>;
        shortCodes?: import("typeorm").Relation<import("../../entities/short-code/short-code.entity").ShortCodeEntity[]>;
        kycs?: import("typeorm").Relation<import("../../entities/kyc/kyc.entity").KYCEntity[]>;
        webhooks?: import("typeorm").Relation<import("../../entities/webhook.entity").WebhookEntity[]>;
        pricingGroup: import("../../entities/product/product-group.entity").ProductGroupEntity;
        lastUpdateID?: string;
        meta?: any;
        createdAt?: string;
        active?: boolean;
        deletedAt?: Date;
        updatedAt?: string;
        creatorId?: string;
        updaterId?: string;
        creator?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        updater?: import("typeorm").Relation<import("@serene-dev/la-nest-library").SDKAuthEntity>;
        orgID?: string;
        order?: number;
        id?: string;
    }>;
    assignClientToProduct(data: AssignProductDto, auth: IAuthParam): Promise<{
        message: string;
    }>;
    getClientIDByAuthID(authID: string): Promise<string>;
    updateWebhookUrl(auth: IAuthParam, webhookUrl: string): Promise<GenericResponseDto>;
    getWebhookUrl(auth: IAuthParam): Promise<{
        webhookUrl?: string;
    }>;
}
export declare class ClientServiceModule {
}
