"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KYCViewServiceModule = exports.KYCViewService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const kyc_view_entity_1 = require("../../entities/kyc/kyc.view.entity");
const utility_service_1 = require("../utility.service");
const client_service_1 = require("../partner/client.service");
const typeorm_3 = require("@nestjs/typeorm");
let KYCViewService = class KYCViewService {
    constructor(repo, repoAnalysis, clientService) {
        this.repo = repo;
        this.repoAnalysis = repoAnalysis;
        this.clientService = clientService;
        this.search = async ({ review, title, description, clientName, reviewer, creator, updater, ...query }, auth) => {
            if (!auth.isAdmin)
                query.clientId = (await this.clientService.authToClient(auth))?.id;
            return await utility_service_1.UtilityClass.searchView(this.repo, query, {
                baseWhere: {
                    review: utility_service_1.UtilityClass.likeFormatter(review),
                    title: utility_service_1.UtilityClass.likeFormatter(title),
                    description: utility_service_1.UtilityClass.likeFormatter(description),
                    clientName: utility_service_1.UtilityClass.likeFormatter(clientName),
                    reviewer: utility_service_1.UtilityClass.likeFormatter(reviewer),
                    creator: utility_service_1.UtilityClass.likeFormatter(creator),
                    updater: utility_service_1.UtilityClass.likeFormatter(updater),
                },
            });
        };
        this.searchAnalysis = async ({ clientName, ...query }, auth) => {
            if (!auth.isAdmin)
                query.clientId = (await this.clientService.authToClient(auth))?.id;
            return await utility_service_1.UtilityClass.searchView(this.repoAnalysis, query, {
                baseWhere: {
                    clientName: utility_service_1.UtilityClass.likeFormatter(clientName),
                },
            });
        };
    }
};
exports.KYCViewService = KYCViewService;
exports.KYCViewService = KYCViewService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(kyc_view_entity_1.KYCView)),
    __param(1, (0, typeorm_2.InjectRepository)(kyc_view_entity_1.KYCAnalysisView)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        client_service_1.ClientService])
], KYCViewService);
let KYCViewServiceModule = class KYCViewServiceModule {
};
exports.KYCViewServiceModule = KYCViewServiceModule;
exports.KYCViewServiceModule = KYCViewServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [
            typeorm_3.TypeOrmModule.forFeature([kyc_view_entity_1.KYCView, kyc_view_entity_1.KYCAnalysisView])
        ],
        providers: [KYCViewService],
        exports: [KYCViewService],
    })
], KYCViewServiceModule);
//# sourceMappingURL=kyc.view.service.js.map