import { Repository } from 'typeorm';
import { KYCAnalysisView, KYCView } from '../../entities/kyc/kyc.view.entity';
import { SearchKYCAnalysisDTO, SearchKYCDTO } from '../../dtos/kyc/kyc.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { ClientService } from '../partner/client.service';
export declare class KYCViewService {
    repo: Repository<KYCView>;
    repoAnalysis: Repository<KYCAnalysisView>;
    protected clientService: ClientService;
    constructor(repo: Repository<KYCView>, repoAnalysis: Repository<KYCAnalysisView>, clientService: ClientService);
    search: ({ review, title, description, clientName, reviewer, creator, updater, ...query }: SearchKYCDTO, auth: IAuthParam) => Promise<import("@serene-dev/la-nest-library").ISearchResponse<KYCView>>;
    searchAnalysis: ({ clientName, ...query }: SearchKYCAnalysisDTO, auth: IAuthParam) => Promise<import("@serene-dev/la-nest-library").ISearchResponse<KYCAnalysisView>>;
}
export declare class KYCViewServiceModule {
}
