"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KYCServiceModule = exports.KYCService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../base.service");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const client_service_1 = require("../partner/client.service");
const kyc_entity_1 = require("../../entities/kyc/kyc.entity");
const file_service_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/services/file.service");
const kyc_template_service_1 = require("./kyc-template.service");
const utility_service_1 = require("../utility.service");
const base_enum_2 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/enums/base.enum");
const typeorm_3 = require("@nestjs/typeorm");
let KYCService = class KYCService extends base_service_1.BaseService {
    constructor(repo, clientService, fileService, kycTemplateService) {
        super(repo, base_enum_1.ETableName.kyc);
        this.repo = repo;
        this.clientService = clientService;
        this.fileService = fileService;
        this.kycTemplateService = kycTemplateService;
        this.deletionStyle = base_enum_2.EDeletionType.hard;
        this.queryStruct = [
            { field: 'userComment', condition: la_nest_library_1.ESearchCondition.contains },
            { field: 'clientId' },
            { field: 'templateId' },
            { field: 'status' },
            { field: 'review', condition: la_nest_library_1.ESearchCondition.contains },
            { field: 'fileId' },
            { field: 'reviewerId' },
        ];
    }
    getSingle(where, auth) {
        auth;
        return this.repo.findOne({
            where: { ...where },
            relations: { reviewer: true, template: true, client: true },
        });
    }
    async _create({ dataURI, fileExtension, ...data }, config) {
        data.clientId =
            data.clientId ||
                (await this.clientService.authIDToClientID(data.creatorId));
        await this.checkIfUniqueBy({
            templateId: data.templateId,
            clientId: data.clientId,
        }, { errorMessage: `KYC has already been uploaded` });
        const template = await this.kycTemplateService.getById(data.templateId);
        if (!template)
            utility_service_1.UtilityClass.throwError({
                message: `Template does not exist`,
                statusCode: 404,
            });
        let kycEntity;
        await this.repo.manager.transaction(async (manager) => {
            kycEntity = await manager.save(kyc_entity_1.KYCEntity, this.repo.create(data));
            const file = await this.fileService.uploadJSON({
                dataURI,
                fileExtension,
                refCat: base_enum_1.EFileRefCat.kyc,
                refNo: kycEntity.id,
                title: template.title,
                creatorId: data.creatorId,
                orgID: data.clientId,
            });
            kycEntity.fileId = file.id;
            kycEntity.file = file;
            await manager.update(kyc_entity_1.KYCEntity, { id: kycEntity.id }, { fileId: kycEntity.fileId });
        });
        return kycEntity;
    }
    async _deleteByID(id, auth) {
        const existing = await this.repo.findOne({
            where: { id },
            withDeleted: true,
        });
        if (!auth.isAdmin &&
            (await this.clientService.getClientIDByAuthID(auth.id)) !=
                existing.clientId)
            utility_service_1.UtilityClass.throwError({ statusCode: 403 });
        const ret = await super._deleteByID(id, auth);
        await this.fileService.deleteSingleFile({ fileID: existing.fileId });
        return ret;
    }
    async setStatus(body, auth) {
        if (!auth?.isAdmin)
            utility_service_1.UtilityClass.throwError({ statusCode: 403 });
        return await this._updateByID(body.id, {
            status: body.status,
            review: body.review,
            reviewerId: auth.id,
        });
    }
};
exports.KYCService = KYCService;
KYCService.path = 'kyc';
exports.KYCService = KYCService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(kyc_entity_1.KYCEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        client_service_1.ClientService,
        file_service_1.FileService,
        kyc_template_service_1.KYCTemplateService])
], KYCService);
let KYCServiceModule = class KYCServiceModule {
};
exports.KYCServiceModule = KYCServiceModule;
exports.KYCServiceModule = KYCServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([kyc_entity_1.KYCEntity])],
        providers: [KYCService],
        exports: [KYCService],
    })
], KYCServiceModule);
//# sourceMappingURL=kyc.service.js.map