import { BaseService } from '../base.service';
import { FindOptionsWhere, Repository } from 'typeorm';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { ICreateConfig } from '@serene-dev/la-nest-library';
import { ClientService } from '../partner/client.service';
import { KYCEntity } from '../../entities/kyc/kyc.entity';
import { CreateKYCDTO, SearchKYCDTO, SetKYCStatusDTO } from '../../dtos/kyc/kyc.dto';
import { FileService } from '@serene-dev/la-nest-library/dist/libs/la-library/src/services/file.service';
import { KYCTemplateService } from './kyc-template.service';
import { EDeletionType } from '@serene-dev/la-nest-library/dist/libs/la-library/src/enums/base.enum';
export declare class KYCService extends BaseService<KYCEntity, SearchKYCDTO> {
    repo: Repository<KYCEntity>;
    protected clientService: ClientService;
    protected fileService: FileService;
    protected kycTemplateService: KYCTemplateService;
    static path: string;
    deletionStyle: EDeletionType;
    constructor(repo: Repository<KYCEntity>, clientService: ClientService, fileService: FileService, kycTemplateService: KYCTemplateService);
    getSingle(where: FindOptionsWhere<KYCEntity>, auth?: IAuthParam): Promise<KYCEntity>;
    _create({ dataURI, fileExtension, ...data }: CreateKYCDTO, config?: ICreateConfig): Promise<KYCEntity>;
    _deleteByID(id: string, auth: IAuthParam): Promise<import("typeorm").DeleteResult>;
    setStatus(body: SetKYCStatusDTO, auth: IAuthParam): Promise<KYCEntity>;
}
export declare class KYCServiceModule {
}
