"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KYCTemplateServiceModule = exports.KYCTemplateService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../base.service");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const kyc_template_entity_1 = require("../../entities/kyc/kyc-template.entity");
const typeorm_3 = require("@nestjs/typeorm");
let KYCTemplateService = class KYCTemplateService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.kycTemplate);
        this.repo = repo;
    }
    getByCode(code) {
        return this.getSingle({
            code: code.trim().toUpperCase(),
        });
    }
    getAll() {
        return this.repo.find();
    }
    getSingle(where, auth) {
        auth;
        return this.repo.findOne({
            where: { ...where },
        });
    }
    async _createChecks(data) {
        data.code = data.code.trim().toUpperCase();
        await this.checkIfUniqueBy({
            code: data.code,
        }, { errorMessage: `Code already exists` });
    }
    async _updateChecks(id, data) {
        data.code = data.code.trim().toUpperCase();
        await this.checkIfUniqueBy({
            code: data.code,
            id: (0, typeorm_1.Not)(id),
        }, { errorMessage: `Code already exists` });
    }
    _create(data, config) {
        return super._create(data, config);
    }
    _updateByID(id, data, config) {
        return super._updateByID(id, data, config);
    }
    async _deleteChecks(ids, auth) {
        await this.checkIfDeletable(async () => !(await this.repo.existsBy({
            kycs: { templateId: (0, typeorm_1.In)(ids), active: true },
        })), {
            errorMessage: 'Active KYCs have been created based on this template. Disable or delete the created KYCs before deletion',
        });
    }
};
exports.KYCTemplateService = KYCTemplateService;
KYCTemplateService.path = 'kyc_template';
exports.KYCTemplateService = KYCTemplateService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(kyc_template_entity_1.KYCTemplateEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], KYCTemplateService);
let KYCTemplateServiceModule = class KYCTemplateServiceModule {
};
exports.KYCTemplateServiceModule = KYCTemplateServiceModule;
exports.KYCTemplateServiceModule = KYCTemplateServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_3.TypeOrmModule.forFeature([kyc_template_entity_1.KYCTemplateEntity])],
        providers: [KYCTemplateService],
        exports: [KYCTemplateService],
    })
], KYCTemplateServiceModule);
//# sourceMappingURL=kyc-template.service.js.map