import { BaseService } from '../base.service';
import { FindOptionsWhere, Repository } from 'typeorm';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { CreateShortCodeDTO } from '../../dtos/short-code.dto';
import { KYCTemplateEntity } from '../../entities/kyc/kyc-template.entity';
import { CreateKYCTemplateDTO, UpdateKYCTemplateDTO } from '../../dtos/kyc/kyc-template.dto';
import { ICreateConfig } from '@serene-dev/la-nest-library/dist/libs/la-library/src/interfaces/index.interface';
export declare class KYCTemplateService extends BaseService<KYCTemplateEntity> {
    repo: Repository<KYCTemplateEntity>;
    static path: string;
    constructor(repo: Repository<KYCTemplateEntity>);
    getByCode(code: string): Promise<KYCTemplateEntity>;
    getAll(): Promise<KYCTemplateEntity[]>;
    getSingle(where: FindOptionsWhere<KYCTemplateEntity>, auth?: IAuthParam): Promise<KYCTemplateEntity>;
    _createChecks(data: CreateKYCTemplateDTO): Promise<void>;
    _updateChecks(id: string, data: UpdateKYCTemplateDTO): Promise<void>;
    _create(data: CreateShortCodeDTO, config?: ICreateConfig): Promise<KYCTemplateEntity>;
    _updateByID(id: string, data: UpdateKYCTemplateDTO, config?: ICreateConfig): Promise<KYCTemplateEntity>;
    _deleteChecks(ids: string[], auth: IAuthParam): Promise<void>;
}
export declare class KYCTemplateServiceModule {
}
