import { ConfigService } from '@nestjs/config';
import { MulterModuleOptions } from '@nestjs/platform-express';
import { ISDKEnvironment, SDKEnvironmentService } from '@serene-dev/la-nest-library';
import { ETheme } from 'src/enums/theme.enum';
export declare class IEnvironment extends ISDKEnvironment {
    LOGS_DEST: string;
    THEME: ETheme;
    NO_DB_STUFF: boolean;
    SYNCHRONIZE: boolean;
    timestampDifferenceFromGMT: number;
    APP_NAME: string;
    PS_SECRET_KEY: string;
    PS_PUBLIC_KEY: string;
    BRICCS_HOST: string;
    BRICCS_PROMOTIONAL_API_KEY: string;
    BRICCS_PROMOTIONAL_CLIENT_ID: string;
    BRICCS_PROMOTIONAL_SHORT_CODE: string;
    BRICCS_TRANSACTIONAL_API_KEY: string;
    BRICCS_TRANSACTIONAL_CLIENT_ID: string;
    BRICCS_TRANSACTIONAL_SHORT_CODE: string;
    HOLLATAGS_HOST: string;
    HOLLATAGS_USER: string;
    HOLLATAGS_PWD: string;
    UPLOADS_ABS_PATH: string;
    MONTY_HOST: string;
    MONTY_USERNAME: string;
    MONTY_PASSWORD: string;
    SSL_KEY: string;
    SSL_CERT: string;
    SSL_CA: string;
    REALTIME_INTERVAL_MIN: number;
}
export declare const evt: IEnvironment;
export declare class EnvironmentService extends SDKEnvironmentService {
    protected configService: ConfigService<IEnvironment>;
    constructor(configService: ConfigService<IEnvironment>);
    get evt(): IEnvironment;
    createMulterOptions(): MulterModuleOptions;
    extractEnvironmentData(_evt: ISDKEnvironment): void;
}
