"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseService = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../enums/base.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("./utility.service");
const analytics_enum_1 = require("../enums/analytics.enum");
class BaseService extends la_nest_library_1.SDKBaseService {
    async getAnalytics(params) {
        if (params?.id)
            return [];
        else {
            const currentYr = new Date().getFullYear();
            return Promise.all([
                {
                    header: 'Last 12 Months Creation',
                    type: analytics_enum_1.EChartType.bar,
                    data: await this.countExtractor(utility_service_1.UtilityClass.monthBackOrdering[new Date().getMonth()].map((m) => ({
                        label: m.short,
                        where: {
                            createdAt: (0, typeorm_1.Like)(`${currentYr}-${m.isoStr}-%`),
                        },
                    }))),
                },
                {
                    header: 'Active Status',
                    type: analytics_enum_1.EChartType.pie,
                    data: await this.countExtractor([
                        { label: 'Active', where: { active: true } },
                        { label: 'Inactive', where: { active: false } },
                    ]),
                },
            ]);
        }
    }
    async countExtractor(queries, repository) {
        const repo = repository || this.repo;
        if (Array.isArray(queries))
            return Promise.all(queries.map(async (x) => ({
                label: x.label,
                value: await repo.count({ where: x.where }),
            })));
        else {
            const columnName = queries.toString();
            const distinctValues = (await repo
                .createQueryBuilder(this.tableName)
                .select(`${columnName}`)
                .distinct(true)
                .andWhere(`${this.tableName}.active = 1`)
                .getRawMany()).map((x) => x[columnName]);
            return Promise.all(distinctValues.map(async (x) => ({
                label: x,
                value: await repo.count({ where: { [columnName]: x } }),
            })));
        }
    }
    get queryStruct() {
        return super.queryStruct.concat(this.skipCreator
            ? [this.idSearchQuery]
            : [
                this.idSearchQuery,
                {
                    field: 'creator',
                    condition: la_nest_library_1.ESearchCondition.leftJoin,
                    tableAlias: base_enum_1.ETableName.authentication,
                },
            ]);
    }
    set queryStruct(value) {
        super.queryStruct = value;
    }
    constructor(repo, tableName) {
        super(repo, tableName);
        this.repo = repo;
        this.tableName = tableName;
        this.skipCreator = false;
        this.idSearchQuery = { field: 'id' };
        this.formatSearchQuery = async (query) => {
            return this.extFormatSearchQuery
                ? this.extFormatSearchQuery(query)
                : query;
        };
    }
}
exports.BaseService = BaseService;
//# sourceMappingURL=base.service.js.map