"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToadScheduler = void 0;
const SimpleIntervalEngine_1 = require("./engines/simple-interval/SimpleIntervalEngine");
const CronJobEngine_1 = require("./engines/cron/CronJobEngine");
class ToadScheduler {
    constructor() {
        this.engines = {};
        this.jobRegistry = {};
    }
    addIntervalJob(job) {
        if (!this.engines.simpleIntervalEngine) {
            this.engines.simpleIntervalEngine = new SimpleIntervalEngine_1.SimpleIntervalEngine();
        }
        this.registerJob(job);
        this.engines.simpleIntervalEngine.add(job);
    }
    addLongIntervalJob(job) {
        return this.addIntervalJob(job);
    }
    addSimpleIntervalJob(job) {
        return this.addIntervalJob(job);
    }
    registerJob(job) {
        if (job.id) {
            if (this.jobRegistry[job.id]) {
                throw new Error(`Job with an id ${job.id} is already registered.`);
            }
            this.jobRegistry[job.id] = job;
        }
    }
    addCronJob(job) {
        if (!this.engines.cronJobEngine) {
            this.engines.cronJobEngine = new CronJobEngine_1.CronJobEngine();
        }
        this.registerJob(job);
        this.engines.cronJobEngine.add(job);
    }
    stop() {
        for (const engine of Object.values(this.engines)) {
            engine === null || engine === void 0 ? void 0 : engine.stop();
        }
    }
    getById(id) {
        const job = this.jobRegistry[id];
        if (!job) {
            throw new Error(`Job with an id ${id} is not registered.`);
        }
        return job;
    }
    existsById(id) {
        const job = this.jobRegistry[id];
        if (!job) {
            return false;
        }
        return true;
    }
    removeById(id) {
        const job = this.jobRegistry[id];
        if (!job) {
            return;
        }
        job.stop();
        delete this.jobRegistry[id];
        return job;
    }
    stopById(id) {
        const job = this.getById(id);
        job.stop();
    }
    startById(id) {
        const job = this.getById(id);
        job.start();
    }
    getAllJobs() {
        return Object.values(this.jobRegistry);
    }
    getAllJobsByStatus(status) {
        return Object.values(this.jobRegistry).filter((value) => {
            return value.getStatus() === status;
        });
    }
}
exports.ToadScheduler = ToadScheduler;
//# sourceMappingURL=toadScheduler.js.map