import { SimpleIntervalJob } from './engines/simple-interval/SimpleIntervalJob';
import { Job, JobStatus } from './common/Job';
import { LongIntervalJob } from './engines/simple-interval/LongIntervalJob';
import { CronJob } from './engines/cron/CronJob';
export declare class ToadScheduler {
    private readonly engines;
    private readonly jobRegistry;
    constructor();
    addIntervalJob(job: SimpleIntervalJob | LongIntervalJob): void;
    addLongIntervalJob(job: LongIntervalJob): void;
    addSimpleIntervalJob(job: SimpleIntervalJob): void;
    private registerJob;
    addCronJob(job: CronJob): void;
    stop(): void;
    getById(id: string): Job;
    existsById(id: string): boolean;
    removeById(id: string): Job | undefined;
    stopById(id: string): void;
    startById(id: string): void;
    getAllJobs(): Job[];
    getAllJobsByStatus(status: JobStatus): Job[];
}
