"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loggingErrorHandler = exports.defaultErrorHandler = void 0;
function defaultErrorHandler(id) {
    return (err) => {
        console.error(`Error while handling task ${id}: ${err.message}`);
    };
}
exports.defaultErrorHandler = defaultErrorHandler;
function loggingErrorHandler(originalError) {
    return (err) => {
        console.error(`Error while trying to log an error: ${err.message}`);
        console.error(`Original error: ${originalError.message}`);
    };
}
exports.loggingErrorHandler = loggingErrorHandler;
//# sourceMappingURL=Logger.js.map