"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
//#region  string */
String.prototype.stripChar = function (character = '/') {
    return (this + '').replace(character, '');
};
String.prototype.lastStripChar = function (character = '/') {
    return this[this?.length - 1] == character ? this.slice(0, this.length - 1) : this;
};
String.prototype.unChar = function (character = '/', replacement = '') {
    let te = '';
    for (let i = 0; i < this.length; i++) {
        const e = this[i];
        te += e != character ? e : '';
    }
    return te.split(character).join(replacement);
};
String.prototype.toSentenceCase = function () {
    return this.replace(/([A-Z])/g, ' $1');
};
String.prototype.replaceAllSubStr = function (character = '/', replacement = '') {
    return this.split(character).join(replacement);
};
String.prototype.addPrecedingChar = function (character, expectedLength) {
    if (this.length >= expectedLength)
        return this;
    return character.repeat(expectedLength - this.length) + this;
};
String.prototype.toCamelCase = function () {
    return this.replace(/(?:^\w|[A-Z]|\b\w|\s+)/g, function (match, index) {
        if (+match === 0)
            return ''; // or if (/\s+/.test(match)) for white spaces
        return index === 0 ? match.toLowerCase() : match.toUpperCase();
    });
};
String.prototype.toTitleCase = function () {
    const result = this.replace(/([A-Z])/g, ' $1');
    return result.charAt(0).toUpperCase() + result.slice(1);
};
//#endregion
//#region  array */
Array.prototype.merge = function () {
    let r = '';
    for (const i of this) {
        r += i;
    }
    return r;
};
Array.prototype.reverseIndex = function (index = 0) {
    return this[this?.length - (1 + index)];
};
Array.prototype.lastItem = function () {
    return this.reverseIndex();
};
Array.prototype.sortByFieldLength = function (field, reverse = false) {
    if (reverse) {
        return this.filter((x) => x != null).sort((b, a) => (a[field]?.length || 0) - (b[field]?.length || 0));
    }
    else {
        return this.filter((x) => x != null).sort((a, b) => (a[field]?.length || 0) - (b[field]?.length || 0));
    }
};
Array.prototype.sort2 = function (field, isString = false, reverse = false) {
    if (reverse)
        return isString
            ? this.filter((x) => x != null).sort((b, a) => sortAlphaNum(a[field]?.toString(), b[field]?.toString()))
            : this.filter((x) => x != null).sort((b, a) => (a[field] || 0) - (b[field] || 0));
    else
        return isString
            ? this.filter((x) => x != null).sort((a, b) => sortAlphaNum(a[field]?.toString(), b[field]?.toString()))
            : this.filter((x) => x != null).sort((a, b) => (a[field] || 0) - (b[field] || 0));
};
Array.prototype.sort3 = function (field, reverse = false) {
    let isString = this.some((x) => isNaN(x[field]));
    return isString ? this.sort2(field, true, reverse) : this.sort2(field, false, reverse);
};
var reA = /[^a-zA-Z]/g;
var reN = /[^0-9]/g;
function sortAlphaNum(a, b) {
    var aA = a?.toUpperCase()?.replace(reA, '');
    var bA = b?.toUpperCase()?.replace(reA, '');
    if (aA === bA) {
        var aN = parseInt(a?.replace(reN, ''), 10);
        var bN = parseInt(b?.replace(reN, ''), 10);
        return aN === bN ? 0 : aN > bN ? 1 : -1;
    }
    else {
        return aA > bA ? 1 : -1;
    }
}
Array.prototype.removeEmptyItems = function (expectedFields, config) {
    // debugger;
    const ignoreBooleanFields = config?.ignoreBooleanFields == true;
    const fieldsType = config?.fieldsType || 'included';
    if (!this.length)
        return this;
    let fieldList;
    if (fieldsType == 'included')
        fieldList = expectedFields?.length ? expectedFields : Object.keys(this[0]);
    else if (fieldsType == 'excluded')
        fieldList = expectedFields?.length
            ? Object.keys(this[0]).filter((x) => !expectedFields.includes(x))
            : Object.keys(this[0]);
    const removedItems = [];
    if (fieldList) {
        for (let i = 0; i < this.length; i++) {
            if (ignoreBooleanFields && i == 0) {
                fieldList = fieldList.filter((f) => typeof this[0][f] != 'boolean');
            }
            const item = this[i];
            if (fieldList.some((f) => item[f] != null))
                continue;
            removedItems.push(...this.splice(i, 1));
            i = i--;
        }
    }
    return removedItems;
};
Array.prototype.toMap = function (arg1, valueMap) {
    // debugger;
    const ret = {};
    if (typeof arg1 == 'function')
        for (const item of this)
            ret[arg1(item)] = item;
    else if (valueMap)
        for (const item of this)
            ret[item[arg1?.toString()]] = valueMap(item);
    else
        for (const item of this)
            ret[item[arg1?.toString()]] = item;
    return ret;
};
Array.prototype.groupBy = function (keyField, keyMap) {
    // debugger;
    const ret = {};
    for (const iterator of this) {
        const group = keyMap ? keyMap(iterator[keyField]) : iterator[keyField];
        if (ret[group])
            ret[group].push(iterator);
        else
            ret[group] = [iterator];
    }
    return ret;
};
Array.prototype.toBooleanMap = function () {
    // debugger;
    const ret = {};
    for (const iterator of this) {
        ret[iterator] = true;
    }
    return ret;
};
Array.prototype.shuffle = function () {
    // debugger;
    const newArr = [];
    while (this.length) {
        newArr.push(...this.splice(Math.floor(Math.random() * this.length - 1), 1));
    }
    return newArr;
};
//#endregion
//#region Function
Function.prototype.clone = function () {
    var that = this;
    var temp = function temporary() {
        return that.apply(this, arguments);
    };
    for (var key in this) {
        if (this.hasOwnProperty(key)) {
            temp[key] = this[key];
        }
    }
    return temp;
};
//# sourceMappingURL=prototypes.js.map