declare global {
    interface String {
        stripChar(character?: string): string;
        lastStripChar(character?: string): string;
        unChar(character?: string, replacement?: string): string;
        /**
         * Converts Pascal case to Sentence case
         * @example 'smallBook'.toSentenceCase() = 'Small Book'
         */
        toSentenceCase(): string;
        /**
         * Replaces all occurrences of a substring
         * @returns The string after replacement
         */
        replaceAllSubStr(character?: string, replacement?: string): string;
        /**
         *
         * @param character Character to add before string
         * @param expectedLength Expected length of the string after addition of the character
         */
        addPrecedingChar(character: string, expectedLength: number): string;
        /**
         * Convert a text into camel case
         * @param text
         */
        toCamelCase(): string;
        /**
         * To title case
         * @param text
         */
        toTitleCase(): string;
    }
    interface Array<T> {
        merge(): T;
        /**
         * @param index The index to select from the end.
         * @defaultValue 0
         * @example ['a','b','c'].reverseIndex(1) returns 'b'
         * @example ['a','b','c','d','e'].reverseIndex(2) returns 'c'
         */
        reverseIndex(index?: number): T;
        lastItem(): T;
        /**
         * Shuffles the content of an array
         */
        shuffle(): T[];
        /**
         * Sort by the length of the field specified in ascending order
         * @param field Field name to compare with
         * @param reverse Should it be in a descending order
         */
        sortByFieldLength(field: keyof T, reverse?: boolean): T[];
        /**
         *
         * @param field Field name to compare with
         * @param isString Is the data type of the field a string
         * @param reverse Should it be in a descending order
         */
        sort2(field: keyof T, isString?: boolean, reverse?: boolean): T[];
        /**
         * Detects the data type of the field to sort by
         * @param field Field name to compare with
         * @param reverse Should it be in a descending order
         */
        sort3(field: keyof T, reverse?: boolean): T[];
        /**
         * Remove items from an array that don't have values in any of its fields
         * @param expectedFields Fields to check for emptiness, the function will remove the items that don't have any value in all the fields specified
         */
        removeEmptyItems(expectedFields?: (keyof T)[], config?: {
            /**
             * Specify whether to check the value in boolean fields.
             * @defaultValue `false`
             */
            ignoreBooleanFields?: boolean;
            /**
             * Specify whether to check for emptiness in the 'expectedFields' or check for emptiness in the other fields excluding the fields specified
             * @defaultValue `included`
             */
            fieldsType?: 'included' | 'excluded';
        }): T[];
        /**
         * Converts an array to a key value pair.
         * @param keyField The field to be used as the key
         * @returns An index object containing the keyField as the index key and each item of the array as value assigned to each index
         */
        toMap(keyField: keyof T): {
            [x: string]: T;
        };
        /**
         * Converts an array to a key value pair.
         * @param keyMap Function to set the key of the map
         */
        toMap(keyMap: (row: T) => string | number): {
            [x: string]: T;
        };
        /**
         * Converts an array to a key value pair.
         * @param keyField The field to be used as the key
         * @param valueMap Function to set the values of each key in the map
         * @returns An index object containing the keyField as the index key and each item of the array as value assigned to each index
         */
        toMap<NT>(keyField: keyof T, valueMap: (item: T) => NT): {
            [x: string]: NT;
        };
        /**
         * Groups an array by unique entries in a field.
         * @param arr Array to be grouped
         * @param keyField The field to be used as the key
         */
        groupBy(keyField: keyof T, keyMap?: (value: any) => string): {
            [x: string]: T[];
        };
        /**
         * Turns an array to a map.
         */
        toBooleanMap(): {
            [x: string]: boolean;
        };
    }
    interface Function {
        clone: any;
    }
}
export {};
