"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EPeriod = exports.Constant = exports.EMenuType = exports.EValidationType = exports.ELanguage = exports.EPageType = exports.Day = exports.EMenuLocation = exports.BtnLg = exports.Btn = exports.Lbl = exports.FKVP = exports.KVP = void 0;
class KVP {
    constructor(key, value, cls) {
        this.key = key;
        this.value = value;
        this.cls = cls;
    }
}
exports.KVP = KVP;
class FKVP extends KVP {
    constructor(key, label, editable, value, inputType, hint, action, formatter, cls, route) {
        super(key, value, cls);
        this.inputType = inputType;
        this.label = label;
        this.hint = hint;
        this.editable = editable;
        this.action = action;
        this.formatter = formatter;
        this.route = route;
    }
}
exports.FKVP = FKVP;
class Lbl {
    constructor(key, value, hint, cls) {
        this.key = key;
        this.value = value || '-';
        this.hint = hint;
        this.cls = cls;
    }
}
exports.Lbl = Lbl;
class Btn {
    constructor(key, action, type, icon, cls, help, showHelpIcon, loading, disabled) {
        this.key = key;
        this.action = action;
        this.type = type;
        this.icon = icon;
        this.cls = cls;
        this.help = help;
        this.showHelpIcon = showHelpIcon;
        this.loading = loading;
        this.disabled = disabled;
    }
}
exports.Btn = Btn;
class BtnLg {
    constructor(key, value, action, cls, extra) {
        this.key = key;
        this.value = value || '-';
        this.action = action;
        this.cls = cls;
        this.extra = extra;
    }
}
exports.BtnLg = BtnLg;
var EMenuLocation;
(function (EMenuLocation) {
    EMenuLocation["viewPage1"] = "viewPage";
})(EMenuLocation || (exports.EMenuLocation = EMenuLocation = {}));
var Day;
(function (Day) {
    Day["sunday"] = "Sunday";
    Day["monday"] = "Monday";
    Day["tuesday"] = "Tuesday";
    Day["wednesday"] = "Wednesday";
    Day["thursday"] = "Thursday";
    Day["friday"] = "Friday";
    Day["saturday"] = "Saturday";
})(Day || (exports.Day = Day = {}));
var EPageType;
(function (EPageType) {
    EPageType["clonePage"] = "Clone";
    EPageType["editPage"] = "Edit";
    EPageType["viewPage"] = "View";
    EPageType["createPage"] = "Create";
    EPageType["indexPage"] = "Index";
})(EPageType || (exports.EPageType = EPageType = {}));
var ELanguage;
(function (ELanguage) {
    ELanguage["EN"] = "EN";
    ELanguage["FR"] = "FR";
})(ELanguage || (exports.ELanguage = ELanguage = {}));
var EValidationType;
(function (EValidationType) {
    EValidationType["email"] = "email";
    EValidationType["entityNumber"] = "entityNumber";
    EValidationType["maxlength"] = "maxlength";
    EValidationType["minlength"] = "minlength";
    EValidationType["mobile"] = "mobile";
    EValidationType["name"] = "name";
    EValidationType["normal"] = "normal";
    EValidationType["passwordNotMatch"] = "passwordNotMatch";
    EValidationType["pattern"] = "pattern";
    EValidationType["required"] = "required";
    EValidationType["unique"] = "unique";
    EValidationType["custom"] = "custom";
})(EValidationType || (exports.EValidationType = EValidationType = {}));
var EMenuType;
(function (EMenuType) {
    EMenuType["horizontal"] = "H";
    EMenuType["vertical"] = "V";
})(EMenuType || (exports.EMenuType = EMenuType = {}));
class Constant {
}
exports.Constant = Constant;
var EPeriod;
(function (EPeriod) {
    EPeriod["daily"] = "daily";
    EPeriod["weekly"] = "weekly";
    EPeriod["monthly"] = "monthly";
    EPeriod["annually"] = "annually";
    EPeriod["yearly"] = "yearly";
    EPeriod["today"] = "today";
    EPeriod["week"] = "week";
    EPeriod["month"] = "month";
    EPeriod["year"] = "year";
    EPeriod["annual"] = "annual";
})(EPeriod || (exports.EPeriod = EPeriod = {}));
//# sourceMappingURL=index.model.js.map