import { Observable } from 'rxjs';
import { SVGIconType } from '../svg-icon/svg-icon.model';
import { InputType } from '../../models/index.model';
export interface IFormSchemaLite<TFormGroup = any, TOption = any, TValue = any> {
    accept?: string;
    asyncValidators?: ((control: any) => Promise<any> | Observable<any>)[];
    autoPickValueField?: boolean;
    checked?: boolean;
    clearOnDisable?: boolean;
    cls?: string;
    countryCode3?: string;
    decimalPoints?: number;
    disabled?: boolean;
    disabledIf?: (row: TValue, cellField?: keyof TFormGroup) => boolean;
    endField?: string;
    errorMessage?: string;
    field: keyof TFormGroup;
    getCountryCode3Key?: string;
    hidden?: boolean;
    hideIfFunc?: (row: TValue) => boolean;
    hint?: string;
    icon?: SVGIconType;
    id?: string;
    initData?: any;
    isSearchField?: boolean;
    label?: string;
    labelField?: keyof TOption;
    max?: number;
    min?: number;
    multiple?: boolean;
    nextField?: keyof TFormGroup;
    noFormat?: boolean;
    noPaste?: boolean;
    onChangeFunc?: (row: TValue, cellField?: keyof TFormGroup, _this?: any) => any;
    optionFormatter?: (item: TOption) => string;
    options?: TOption[];
    optionsAsync?: Observable<TOption[]> | Promise<TOption[]>;
    optionsFunc?: (row: any, cellField?: keyof TFormGroup) => Promise<any[]> | Observable<any[]>;
    optionsInitFunc?: () => Observable<TOption[]>;
    optionsKey?: string;
    order?: string;
    placeholder?: string;
    prefix?: string;
    required?: boolean;
    searchFunc?: (...args: any[]) => any;
    setAsCountryCode3?: boolean;
    showEmptyOption?: boolean;
    showSeperateLabel?: boolean;
    showValidation?: boolean;
    showValidationIcon?: boolean;
    showValidationMsg?: boolean;
    startField?: string;
    sub?: IFormSchemaLite[];
    templateValue?: any;
    type?: InputType;
    validators?: ((control: any) => any)[];
    value?: any;
    valueField?: keyof TOption;
}
export interface IFormOptions {
    [field: string]: any;
}
