import { ActivatedRoute } from '@angular/router';
import { WebSocketSubject } from 'rxjs/webSocket';
import { EnvironmentClass } from './environment.class.lite';
/**
 * Class for the environment object
 */
export declare class Environment extends EnvironmentClass {
    production: boolean;
    apiBaseUrl?: string;
    /**
     * Current activated route
     */
    activatedRoute: ActivatedRoute;
    socket: WebSocketSubject<any>;
    /**
     *
     * @param production Specify whether it is a production environment
     * @param name Name of the environment
     * @param apiBaseUrl Base url of the server api
     */
    constructor(production: boolean, name: string, apiBaseUrl?: string);
}
